/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.dao;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.context.SqlContext;
import ext.scf4.model.ScfPropertyElement;
import java.util.List;

public class ScfAbstractPropertyDAO
extends OrmAbstractDAO<ScfPropertyElement> {
    protected String column_key = "key_";
    protected String column_index = "index_";
    protected String column_value = "value_";

    public ScfAbstractPropertyDAO() {
        super(new ScfPropertyElement[0]);
    }

    public void putPropertyElement(DtsSession dtsSession, ScfPropertyElement propertyElement) throws Exception {
        this.getPersistenceProxy().putEntitys_3(dtsSession, this.getTableName(), propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, String key, int index, CharSequence value) throws Exception {
        ScfPropertyElement propertyElement = new ScfPropertyElement();
        propertyElement.key = key;
        propertyElement.index = index;
        propertyElement.value = BcStringUtil.toString(value);
        this.putPropertyElement(dtsSession, propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, String key, String value) throws Exception {
        this.putPropertyElement(dtsSession, key, 1, value);
    }

    public ScfPropertyElement getPropertyElement(DtsSession dtsSession, String key, int index) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getViewName() + " WHERE " + this.column_key + sqlContext.toCondition_string("=", key) + " AND " + this.column_index + "=" + index;
        return (ScfPropertyElement)this.getEntity(dtsSession, query);
    }

    public String getValue(DtsSession dtsSession, String key, int index) throws Exception {
        ScfPropertyElement propertyElement = this.getPropertyElement(dtsSession, key, index);
        if (propertyElement != null) {
            return propertyElement.value;
        }
        return null;
    }

    public String getValue(DtsSession dtsSession, String key) throws Exception {
        return this.getValue(dtsSession, key, 1);
    }

    public List<ScfPropertyElement> getPropertyElementList(DtsSession dtsSession) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getViewName() + " ORDER BY " + this.column_key + ", " + this.column_index;
        return this.getEntityList(dtsSession, query);
    }
}

