/*
 * Decompiled with CFR 0.152.
 */
package ext.scf2.client;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.thread.BcThread;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.scf.stub.ScfHandleStub;
import ext.scf2.rmo.ScfFileRMO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class ScfFileUploader
extends BcThread {
    protected RmiAgent agent;
    protected String handleId;
    protected boolean eod;
    protected int fileSize;
    protected int transferdSize;
    protected int tmpCnt;
    protected BufferedInputStream is;
    protected File localFile;
    protected String svFilePath;
    protected BcMonitor paMon;
    protected BcEventHandler eventHandler;
    protected int chunkSize = 4096;

    public ScfFileUploader(RmiAgent agent) throws Exception {
        this.agent = agent;
        this.setPriority(5);
    }

    public synchronized void upload(File localFile, String svFilePath, BcMonitor paMon, BcEventHandler eventHandler) throws Exception {
        BcLogUtil.debug("upload:localFile.getPath()=" + localFile.getPath());
        this.localFile = localFile;
        this.svFilePath = svFilePath;
        this.paMon = paMon;
        this.eventHandler = eventHandler;
        this.eod = false;
        this.handleId = null;
        this.transferdSize = 0;
        if (paMon != null) {
            paMon.lock();
        }
        this.getHandle();
        this.is = new BufferedInputStream(new FileInputStream(localFile));
        this.startThread();
    }

    protected void parentUnLock() {
        if (this.paMon != null) {
            this.paMon.unLock();
        }
    }

    protected void getHandle() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfFileRMO.class.getName());
        rmiReq.setMethodName("getUploadHandle");
        rmiReq.addData(this.svFilePath);
        rmiReq.addData(this.localFile.getName());
        rmiReq.addData(new Long(this.localFile.lastModified()));
        rmiReq.addData(new Long(this.localFile.length()));
        RmiRespons rmiRes = this.agent.invoke(rmiReq);
        this.handleId = rmiRes.getDataAsString("hId");
    }

    @Override
    protected void run2() throws Exception {
        while (!this.eod) {
            try {
                this.uploadNextBinary();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                break;
            }
        }
        try {
            this.is.close();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        try {
            ScfHandleStub.getInstance().removeHandle(this.handleId);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        this.suspendThread();
        this.parentUnLock();
    }

    protected void uploadNextBinary() throws Exception {
        byte[] byteArray = new byte[this.chunkSize];
        this.tmpCnt = this.is.read(byteArray, 0, byteArray.length);
        this.transferdSize += this.tmpCnt;
        if (this.tmpCnt >= 0) {
            RmiRequest rmiReq = new RmiRequest();
            rmiReq.setClassName(ScfFileRMO.class.getName());
            rmiReq.setMethodName("uploadBinary");
            rmiReq.addData(this.handleId);
            if (this.tmpCnt == byteArray.length) {
                rmiReq.addData(byteArray);
            } else {
                byte[] tmpByteArray = new byte[this.tmpCnt];
                System.arraycopy(byteArray, 0, tmpByteArray, 0, this.tmpCnt);
                rmiReq.addData(tmpByteArray);
            }
            RmiRespons rmiRespons = this.agent.invoke(rmiReq);
        } else {
            this.eod = true;
        }
    }
}

