/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import ext.appfw.common.AfbConstants;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCsvUtil;
import ext.base.util.BcProcessExecutor;
import ext.lib.awt.AwtImageUtil;
import ext.module.xfil.common.FfpegParam;
import ext.module.xfil.common.FfpegText;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.model.XfilUriEntity;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class XfilCaptureUtil2
extends BcLoggableObject {
    private XfilCaptureUtil2() {
    }

    public static XfilCaptureUtil2 getInstance() {
        return SingletonHolder.instance;
    }

    public void proc1(XfilUriEntity uriEntity, XfilCaptureParam videoCaptureParam, File dir) throws Exception {
        File imputFile = XfilUtil.toFile(uriEntity);
        this.getLogger().info("imputFile=" + imputFile.getPath());
        if (imputFile.exists()) {
            try {
                this.proc2(uriEntity, imputFile, videoCaptureParam, dir);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                uriEntity.error2 = ex.getMessage();
                this.getLogger().debug("uriEntity.error1=" + uriEntity.error2);
            }
        } else {
            this.getLogger().info("Not found file:" + imputFile.getPath());
            uriEntity.missingDatetime = BcTimeUtil.createCalendar();
        }
        uriEntity.thumbnailDatetime = BcTimeUtil.createCalendar();
    }

    public void proc2(XfilUriEntity uriEntity, File imputFile, XfilCaptureParam videoCaptureParam, File dir) throws Exception {
        if (uriEntity.durationMillis <= 0L) {
            uriEntity.error1 = "duration=" + uriEntity.durationMillis;
            this.getLogger().debug("uriEntity.error1=" + uriEntity.error1);
            return;
        }
        ArrayList<Long> startTimeMillisList = new ArrayList<Long>();
        int i = 0;
        while (i < videoCaptureParam.capturingCount) {
            long startTimeMillis = videoCaptureParam.top + videoCaptureParam.interval * (long)i;
            startTimeMillisList.add(startTimeMillis);
            ++i;
        }
        XfilUtil.deleteTthumbnails(uriEntity);
        ArrayList fileList1 = new ArrayList();
        BcProcessExecutor.BcProcessResult processResultErr = null;
        int i2 = 0;
        while (i2 < startTimeMillisList.size()) {
            Long startTimeMillis = (Long)startTimeMillisList.get(i2);
            String extention = AwtImageUtil.ImageFileType.JPG.extentions[0];
            String fileName = XfilUtil.createFileName(startTimeMillis, videoCaptureParam.width, videoCaptureParam.height, uriEntity.id, extention, imputFile.getName());
            File outputFile = new File(dir, fileName);
            BcFileUtil.makeParent(outputFile);
            BcFileUtil.deleteIfExists(outputFile);
            Object[] res = this.executeFfmpeg(uriEntity, imputFile, startTimeMillis, videoCaptureParam, outputFile.getPath());
            BcProcessExecutor.BcProcessResult processResult = (BcProcessExecutor.BcProcessResult)res[0];
            if (processResult.exitValue != AfbConstants.ExitCode.OK.code) {
                processResultErr = processResult;
                break;
            }
            List fileList2 = (List)res[1];
            if (fileList2 != null) {
                fileList1.addAll(fileList2);
            }
            ++i2;
        }
        this.getLogger().debug("fileList1.size()=" + fileList1.size());
        if (fileList1.size() > 0) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (File file : fileList1) {
                fileNameList.add(file.getName());
            }
            uriEntity.thumbnailFiles = BcCsvUtil.toCsv(fileNameList);
        }
        if (processResultErr != null) {
            uriEntity.error2 = processResultErr.out;
        }
    }

    public Object[] executeFfmpeg(XfilUriEntity uriEntity, File imputFile, long startTimeMillis, XfilCaptureParam videoCaptureParam, String outputPath) throws Exception {
        FfpegParam ffpegParam = new FfpegParam();
        ffpegParam.inputPath = imputFile.getPath();
        ffpegParam.outputPath = outputPath;
        ffpegParam.startTimeMillis = startTimeMillis;
        if (videoCaptureParam.elapsedTime) {
            ffpegParam.ffpegTextList = new ArrayList<FfpegText>();
            FfpegText ffpegText = new FfpegText();
            int margin = 10;
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 0) {
                ffpegText.x = "(w-tw)/2";
            }
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 2) {
                ffpegText.x = String.valueOf(margin);
            }
            if (videoCaptureParam.elapsedTimeHorizontalPositionId == 4) {
                ffpegText.x = "w-tw-" + margin;
            }
            if (videoCaptureParam.elapsedTimeVerticalPositionId == 0) {
                ffpegText.y = "(h-th)/2";
            } else if (videoCaptureParam.elapsedTimeVerticalPositionId == 1) {
                ffpegText.y = String.valueOf(margin);
            } else if (videoCaptureParam.elapsedTimeVerticalPositionId == 3) {
                ffpegText.y = "h-th-" + margin;
            }
            ffpegText.fontSize = 20;
            ffpegText.fontColor = Color.WHITE;
            ffpegText.text = BcTimeUtil.toDurationString(ffpegParam.startTimeMillis);
            ffpegText.text = ffpegText.text.replace(":", "\\:");
            ffpegText.borderw = 1;
            ffpegText.borderColor = Color.BLACK;
            ffpegParam.ffpegTextList.add(ffpegText);
        }
        XfilCaptureUtil.setParam(videoCaptureParam, ffpegParam);
        return XfilCaptureUtil.executeFfmpeg(ffpegParam);
    }

    /* synthetic */ XfilCaptureUtil2(XfilCaptureUtil2 xfilCaptureUtil2) {
        this();
    }

    private static final class SingletonHolder {
        private static final XfilCaptureUtil2 instance = new XfilCaptureUtil2(null);

        private SingletonHolder() {
        }
    }
}

