/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcLangUtil;
import ext.base.event.BcEvent;
import ext.base.event.BcEventHandlerList;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxNumberField;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.libx.etc.model.EtcQueryCondition;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsAndOrPane;
import ext.module.xdts.fx.XdtsOptionSelectionPane;
import ext.module.xdts.fx.XdtsPatternMatchPane;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xmmd.fx.XmmdSqlTypeChoiceBox;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.layout.Region;

public class XdtsControlOptionPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField tableColumnNameField = new FxTextField();
    XmmdSqlTypeChoiceBox sqlTypeChoiceBox = new XmmdSqlTypeChoiceBox();
    FxTextField itemNameField = new FxTextField();
    FxComboBox<String> controlTypeComboBox = new InnerComboBox<String>();
    FxNumberField displayOrderField = new FxNumberField(-1, 0, false);
    FxNumberField columnCountField = new FxNumberField(-1, 0, false);
    FxNumberField rowCountField = new FxNumberField(-1, 0, false);
    XdtsAndOrPane andOrPane = new XdtsAndOrPane();
    XdtsPatternMatchPane patternMatchPane = new XdtsPatternMatchPane();
    FxTextArea selectionTextArea = new FxTextArea();
    FxTextField defaultValueField = new FxTextField();
    FxTextArea descriptionTextArea = new FxTextArea();
    XdtsProfile profile;
    XdtsControlContext controlContext;
    int rowLimit = 20;
    FxButton completionButton;
    FxButton cancelButton;
    boolean isCompleted;
    BcEventHandlerList closeHandlerList = new BcEventHandlerList();
    FxTabPane tabPane1 = new FxTabPane();
    XdtsOptionSelectionPane optionSelectionPane1;
    XdtsOptionSelectionPane optionSelectionPane2;

    public XdtsControlOptionPane(XdtsProfile profile) throws Exception {
        this.profile = profile;
        XdtsConstants.ControlType[] controlTypeArray = XdtsConstants.ControlType.values();
        int n = controlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            XdtsConstants.ControlType \uff43ontrolType = controlTypeArray[n2];
            this.controlTypeComboBox.getItems().add((Object)\uff43ontrolType.name());
            ++n2;
        }
        this.completionButton = FxUtil.createCompletionButton();
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
    }

    protected void setControlContext(XdtsControlContext controlContext) throws Exception {
        this.controlContext = controlContext;
        this.itemNameField.setText(controlContext.itemName);
        this.tableColumnNameField.setText(controlContext.tableColumnName);
        this.sqlTypeChoiceBox.setSqlTypeId(controlContext.sqlTypeId);
        if (controlContext.controlType != null) {
            this.controlTypeComboBox.getSelectionModel().select((Object)controlContext.controlType.name());
        }
        this.columnCountField.setValue(controlContext.columnCount);
        this.rowCountField.setValue(controlContext.rowCount);
        if (controlContext.patternMatch != null) {
            this.patternMatchPane.setPatternMatch(controlContext.patternMatch);
        }
        this.selectionTextArea.setText(controlContext.options);
        this.defaultValueField.setText(controlContext.defaultValue);
        this.descriptionTextArea.setText(controlContext.description);
        this.displayOrderField.setValue(controlContext.displayOrder);
        this.initComponent();
    }

    protected void storeData() throws Exception {
        this.controlContext.tableColumnName = this.tableColumnNameField.getText();
        this.controlContext.sqlTypeId = this.sqlTypeChoiceBox.getSqlTypeId();
        this.controlContext.isAnd = this.andOrPane.isAnd();
        this.controlContext.itemName = this.itemNameField.getText();
        String controlTypeName = (String)this.controlTypeComboBox.getSelectionModel().getSelectedItem();
        this.controlContext.controlType = BcLangUtil.getEnumByName(XdtsConstants.ControlType.class, controlTypeName);
        if (this.columnCountField.getBigDecimal() != null) {
            this.controlContext.columnCount = this.columnCountField.getBigDecimal().intValue();
        }
        if (this.rowCountField.getBigDecimal() != null) {
            this.controlContext.rowCount = this.rowCountField.getBigDecimal().intValue();
        }
        this.controlContext.patternMatch = this.patternMatchPane.getPatternMatch();
        this.controlContext.options = this.selectionTextArea.getText();
        this.controlContext.defaultValue = this.defaultValueField.getText();
        this.controlContext.description = this.descriptionTextArea.getText();
        this.controlContext.displayOrder = this.displayOrderField.getBigDecimal().intValue();
    }

    protected void initComponent() throws Exception {
        this.centerPane.removeAll();
        this.itemNameField.setPrefColumnCount(80);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().itemName.toPlain()), new Node[]{this.itemNameField});
        this.centerPane.addNodeUnit(controlUnit);
        if (this.controlContext.contextType == XdtsConstants.ContextType.General) {
            this.tableColumnNameField.setPrefColumnCount(80);
            controlUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().tableName_columnName), new Node[]{this.tableColumnNameField});
            this.centerPane.addNodeUnit(controlUnit);
            controlUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().sqlType.toPlain()), new Node[]{this.sqlTypeChoiceBox});
            this.centerPane.addNodeUnit(controlUnit);
            if (XdtsSqlParserUtil.isTextType(this.controlContext.sqlTypeId) || XdtsSqlParserUtil.isNumberType(this.controlContext.sqlTypeId)) {
                controlUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().controlType.toPlain()), new Node[]{this.controlTypeComboBox});
                this.centerPane.addNodeUnit(controlUnit);
                this.columnCountField.setPrefColumnCount(4);
                controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().numberOfColumns.toPlain()), new Node[]{this.columnCountField});
                this.centerPane.addNodeUnit(controlUnit);
                this.rowCountField.setPrefColumnCount(4);
                controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().numberOfRows.toPlain()), new Node[]{this.rowCountField});
                this.centerPane.addNodeUnit(controlUnit);
            }
            if (XdtsSqlParserUtil.isTextType(this.controlContext.sqlTypeId)) {
                FxUtil.setFixedSize((Region)this.patternMatchPane, 400.0, 28.0);
                controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().matchMethod.toPlain()), new Node[]{this.patternMatchPane});
                this.centerPane.addNodeUnit(controlUnit);
                this.selectionTextArea.setPrefColumnCount(80);
                this.selectionTextArea.setPrefRowCount(4);
                controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().candidate), new Node[]{this.selectionTextArea});
                this.centerPane.addNodeUnit(controlUnit);
            }
        }
        if (this.controlContext.contextType == XdtsConstants.ContextType.General || this.controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            this.defaultValueField.setPrefColumnCount(80);
            controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().defaltValue.toPlain()), new Node[]{this.defaultValueField});
            this.centerPane.addNodeUnit(controlUnit);
        }
        this.descriptionTextArea.setPrefColumnCount(80);
        this.descriptionTextArea.setPrefRowCount(2);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().explanation), new Node[]{this.descriptionTextArea});
        this.centerPane.addNodeUnit(controlUnit);
        this.displayOrderField.setPrefColumnCount(5);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().displayOrder.toPlain()), new Node[]{this.displayOrderField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData();
            this.isCompleted = true;
            this.closeHandlerList.fireEvent(new BcEvent((Object)this));
        } else if (ev.getSource() == this.cancelButton) {
            this.closeHandlerList.fireEvent(new BcEvent((Object)this));
        }
    }

    public void func1() throws Exception {
        EtcQueryCondition queryCondition = new EtcQueryCondition();
        queryCondition.datasourceName = this.profile.name;
        queryCondition.columNameList = new ArrayList<String>();
        queryCondition.ascending = false;
        queryCondition.rowLimit = this.rowLimit;
        this.optionSelectionPane1 = new XdtsOptionSelectionPane(queryCondition);
        Tab tab1 = new Tab();
        tab1.setText(String.valueOf(XdtsWords.getInstance().\u51fa\u73fe\u983b\u5ea6\u4e0a\u4f4d) + this.rowLimit + "\u4ef6");
        tab1.setContent((Node)this.optionSelectionPane1);
        tab1.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)tab1);
        queryCondition = new EtcQueryCondition();
        queryCondition.datasourceName = this.profile.name;
        queryCondition.columNameList = new ArrayList<String>();
        queryCondition.ascending = true;
        queryCondition.rowLimit = this.rowLimit;
        this.optionSelectionPane2 = new XdtsOptionSelectionPane(queryCondition);
        tab1 = new Tab();
        tab1.setText(String.valueOf(XdtsWords.getInstance().\u51fa\u73fe\u983b\u5ea6\u4e0b\u4f4d) + this.rowLimit + "\u4ef6");
        tab1.setContent((Node)this.optionSelectionPane2);
        tab1.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)tab1);
        this.setBottom((Node)this.tabPane1);
    }

    public List<Object> getValueList() throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (this.optionSelectionPane1 != null) {
            valueList.addAll(this.optionSelectionPane1.getValueList());
        }
        if (this.optionSelectionPane2 != null) {
            valueList.addAll(this.optionSelectionPane2.getValueList());
        }
        return valueList;
    }

    class InnerComboBox<T>
    extends FxComboBox<T> {
        @Override
        protected void valueChanged(ObservableValue ov, T oldValue, T newValue) {
        }
    }
}

