/*
 * Decompiled with CFR 0.152.
 */
package ext.module.scrp.fx;

import ext.base.log.BcLogUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.script.SrpUtil;
import ext.lib.script.SrpWords;
import ext.libx.fx.FxxEditEvent;
import ext.module.scrp.model.ScrpScript;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class ScrpScriptPane_bak
extends FxDecoratePane {
    protected BorderPane borderPane1 = new BorderPane();
    protected FxFlowPane topPane = new FxFlowPane(11);
    protected FxTextField nameField = new FxTextField();
    protected FxTextField engineField = new FxTextField();
    protected FxTextArea textArea = new FxTextArea();
    protected FxTextArea noteArea = new FxTextArea();
    protected Button testButton;
    protected Button saveButton;
    protected Button closeButton;
    protected ScrpScript script;
    public boolean isSave;
    protected Stage stage;
    EventHandler<? super FxxEditEvent> eventHandler;

    public ScrpScriptPane_bak() throws Exception {
        this.testButton = this.createButton(SrpWords.getInstance().testCompile);
        this.saveButton = this.createButton(BcWords.getInstance().save);
        this.closeButton = this.createButton(BcWords.getInstance().close);
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.nameField.setPrefColumnCount(60);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(SrpWords.getInstance().script), new Node[]{this.nameField});
        this.topPane.addNodeUnit(nodeUnit);
        this.engineField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SrpWords.getInstance().engine), new Node[]{this.engineField});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefSize(500.0, 80.0);
        this.borderPane1.setTop((Node)this.topPane);
        this.noteArea.setPrefSize(500.0, 120.0);
        this.borderPane1.setBottom((Node)this.noteArea);
        this.borderPane1.setCenter((Node)this.textArea);
        this.setCenter((Node)this.borderPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setData(ScrpScript script) throws Exception {
        this.script = script;
        this.nameField.setText(script.name);
        this.engineField.setText(script.engine);
        this.textArea.setText(script.script);
        this.noteArea.setText(script.note);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.testButton) {
            BcResult result = SrpUtil.compileTest(this.engineField.getText(), this.textArea.getText());
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList()).toString();
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().warning, 2);
            } else {
                String msg = "\u30b3\u30f3\u30d1\u30a4\u30eb\u306f\u6210\u529f\u3057\u307e\u3057\u305f";
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().information, 1);
            }
        } else if (ev.getSource() == this.saveButton) {
            this.script.name = this.nameField.getText();
            this.script.engine = this.engineField.getText();
            this.script.script = this.textArea.getText();
            this.script.note = this.noteArea.getText();
            this.close();
            if (this.eventHandler != null) {
                FxxEditEvent ev2 = new FxxEditEvent(this.script, null, FxxEditEvent.DONE);
                this.eventHandler.handle((Event)ev2);
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void setEventHandler(EventHandler<? super FxxEditEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.isSave = false;
        if (this.script == null) {
            ScrpScript script = new ScrpScript();
            script.engine = "javascript";
            this.setData(script);
        }
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    ScrpScriptPane_bak.this.textArea.requestFocus();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(860.0);
        this.stage.setHeight(600.0);
        this.stage.setResizable(true);
        this.stage.setTitle(SrpWords.getInstance().script);
        this.stage.show();
    }
}

