/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.swg.docviewer;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.doc.util.DcfBookFile;
import ext.lib.doc.util.DcfPageReader;
import ext.lib.doc.util.DcfPageable;
import ext.lib.doc.util.DcfPrintable;
import ext.lib.pdf.PdfConstants;
import ext.lib.print.DcfPrintUtil;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgUtil;
import ext.libx.swg.docviewer.DcfPdfDilog;
import ext.libx.swg.docviewer.DcfViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;

public class DcfDocumentViewer {
    public static final int MODE_review = 11;
    public static final int MODE_printDialog = 21;
    public static final int MODE_printOut = 22;
    protected File localDocFile;
    protected File tempDir;
    protected String title = "untitled";
    protected File pdfFile;
    protected int mode = 11;
    protected double outputTopMargin = 0.0;
    protected double outputLeftMargin = 0.0;
    protected boolean isStored;
    protected DcfPageReader bookReader;
    protected DcfViewerPanel viewrPanel;
    protected Component ownerCompo;
    protected SwgFrame frame;
    public boolean printButtonEnabled = true;

    public Component getOwnerComponent() {
        return this.ownerCompo;
    }

    public DcfPageReader getPageReader() {
        return this.bookReader;
    }

    public DcfViewerPanel getViewerPanel() throws Exception {
        if (this.viewrPanel == null) {
            this.viewrPanel = new DcfViewerPanel(this);
            this.viewrPanel.setPageReader(this.bookReader);
        }
        this.viewrPanel.checkOption();
        return this.viewrPanel;
    }

    public void setTempolaryDirectry(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setOutputTopMargin(double outputTopMargin) {
        this.outputTopMargin = outputTopMargin;
    }

    public void setOutputLeftMargin(double outputLeftMargin) {
        this.outputLeftMargin = outputLeftMargin;
    }

    public void setOutputPdfFile(File pdfFile) {
        this.pdfFile = pdfFile;
    }

    public boolean setBookReader(DcfPageReader bookReader) throws Exception {
        boolean printFlag = false;
        if (bookReader.getPageCount() <= 0) {
            JOptionPane.showMessageDialog(this.getOwnerComponent(), "\u30da\u30fc\u30b8\u306f\u3042\u308a\u307e\u305b\u3093\u3002", BcWords.getInstance().information, 1);
            return printFlag;
        }
        this.bookReader = bookReader;
        switch (this.mode) {
            case 11: {
                this.getFrame().setVisible(true);
                break;
            }
            case 21: 
            case 22: {
                printFlag = this.printOut(-1);
            }
        }
        return printFlag;
    }

    public void setLocalFile(File localDocFile) throws Exception {
        BcLogUtil.debug("setLocalFile:localDocFile.getPath()=" + localDocFile.getPath());
        this.localDocFile = localDocFile;
        DcfBookFile bookFile = new DcfBookFile();
        bookFile.setReadMode(localDocFile);
        this.bookReader = bookFile;
        this.getViewerPanel().pageNoComboEventEnabled = true;
    }

    protected File createTemporaryFile() throws Exception {
        if (!this.tempDir.exists()) {
            try {
                this.tempDir.mkdirs();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                throw new Exception("\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u304a\u3044\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            }
        }
        File file = File.createTempFile("doc", ".tmp", this.tempDir);
        return file;
    }

    protected void setServerSideTemporaryFileToOfiicial() throws Exception {
    }

    public boolean printOut(int pageIndex) throws Exception {
        DcfPageable pageable;
        boolean printFlag = false;
        PrintService printService = DcfPrintUtil.getDefaultPrintService();
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (!BcStringUtil.isEmpty(this.title)) {
            printRequestAttributeSet.add(new JobName(this.title, Locale.getDefault()));
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (pageIndex >= 0) {
            DcfPage dcfPage = this.bookReader.getPage(pageIndex);
            DcfBook tmpDcfBook = new DcfBook();
            tmpDcfBook.addPage(dcfPage);
            DcfPrintable printable = new DcfPrintable(tmpDcfBook);
            DcfPageable pageable2 = new DcfPageable(tmpDcfBook);
            PageFormat pageFormat = pageable2.getPageFormat(pageIndex);
            printerJob.setPrintable(printable, pageFormat);
            printerJob.setPageable(pageable2);
            BcLogUtil.debug("printOut:pageFormat.getOrientation()=" + pageFormat.getOrientation());
        } else {
            DcfPrintable printable = new DcfPrintable(this.bookReader);
            printerJob.setPrintable(printable);
            pageable = new DcfPageable(this.bookReader);
            printerJob.setPageable(pageable);
        }
        switch (this.mode) {
            case 11: 
            case 21: {
                printRequestAttributeSet.add(new Copies(1));
                printRequestAttributeSet.add(Chromaticity.COLOR);
                DummyDialog dummyDialog = new DummyDialog();
                if (!dummyDialog.printDialog(printerJob, printRequestAttributeSet)) break;
                printerJob.print(printRequestAttributeSet);
                printFlag = true;
                break;
            }
            case 22: {
                pageable = new DcfPageable(this.bookReader);
                printRequestAttributeSet.add(new Copies(1));
                printerJob.setPrintService(printService);
                printerJob.setPageable(pageable);
                printerJob.print(printRequestAttributeSet);
                printFlag = true;
            }
        }
        return printFlag;
    }

    public void createPdf() throws Exception {
        if (this.pdfFile == null) {
            this.setOutputPdfFile(new File(String.valueOf(this.title) + "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + PdfConstants.EXTENTION_dot_pdf));
        }
        DcfPdfDilog pdfDialog = new DcfPdfDilog();
        if (this.localDocFile != null) {
            pdfDialog.showAsDialog(this.localDocFile, this.pdfFile, this.title, (Component)this.frame);
        } else {
            pdfDialog.showAsDialog(this.bookReader, this.pdfFile, this.title, (Component)this.frame);
        }
    }

    protected synchronized void closeTransaction() {
        if (this.localDocFile != null) {
            try {
                if (!this.isStored) {
                    this.localDocFile.delete();
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        this.frame.dispose();
    }

    protected SwgFrame getFrame() throws Exception {
        if (this.frame != null) {
            return this.frame;
        }
        this.frame = new SwgFrame();
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.getViewerPanel(), "Center");
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    DcfDocumentViewer.this.closeTransaction();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.frame.setResizable(true);
        if (!BcStringUtil.isEmpty(this.title)) {
            this.frame.setTitle(this.title);
        }
        this.frame.setIconImage(AwtImageHelper.getImage("printer_view_64x64.png"));
        SwgUtil.setCenter(this.frame, 0.0);
        return this.frame;
    }

    class DummyDialog
    extends JDialog {
        DummyDialog() {
        }

        public boolean printDialog(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
            this.setUndecorated(true);
            this.setSize(0, 0);
            this.setVisible(true);
            this.toFront();
            boolean b = printerJob.printDialog(printRequestAttributeSet);
            this.setVisible(false);
            this.dispose();
            return b;
        }
    }
}

