/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.base.core.BcInteger;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.orm.entity.OrmDataId;
import ext.lib.orm.entity.OrmGeneralData;
import ext.lib.orm.persistence.OrmAbstractPersistence;
import ext.lib.orm.persistence.OrmPersistenceProxy;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSetClause;
import ext.lib.sql.model.SqlUpdateQuery;
import ext.lib.sql.model.SqlWhereElement;
import java.sql.PreparedStatement;
import java.util.List;

public class OrmPersistenceDataId
extends OrmAbstractPersistence {
    @Override
    public void setSetClause(SqlContext sqlContext, List<String> setElementList, Object dataObject) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmDataId etdmDataId = (OrmDataId)dataObject;
        setElementList.add("id=" + etdmDataId.getDataId());
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, Object dataObject) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmDataId etdmDataId = (OrmDataId)dataObject;
        updateQuery.addSetClause(new SqlSetClause("id", etdmDataId.getDataId()));
    }

    @Override
    public void setSetClause(List<String> setColumnList, Class entityType) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(entityType)) {
            return;
        }
        setColumnList.add("id");
    }

    @Override
    public void setValueList(List<Object> valueList, Object dataObject) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmDataId etdmDataId = (OrmDataId)dataObject;
        valueList.add(etdmDataId.getDataId());
    }

    @Override
    public void getJdbcTypes(List<Integer> sqlTypeList, Class entityType) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(entityType)) {
            return;
        }
        sqlTypeList.add(4);
    }

    @Override
    public void setPreStmtValue(SqlContext sqlContext, PreparedStatement preStmt, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmDataId etdmDataId = (OrmDataId)dataObject;
        sqlContext.setPreStmtValue(preStmt, columnIndex, etdmDataId.getDataId(), (Object)4);
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, OrmGeneralData generalData, Class entityType) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(entityType)) {
            return;
        }
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (mmdField.columnName.equals("id")) {
                updateQuery.addSetClause(new SqlSetClause("id", valueObject));
            }
            ++i;
        }
    }

    @Override
    public void getSelectColumnName(List<String> columnNameList, String tableAlias, Class entityType) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(entityType)) {
            return;
        }
        String tableAlias2 = SqlUtil.tableAliasToNotNull(tableAlias);
        columnNameList.add(String.valueOf(tableAlias2) + "id");
    }

    @Override
    public void setResultSet(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmDataId.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmDataId etdmDataId = (OrmDataId)dataObject;
        SqlContext sqlContext = dtsSession.getSqlContext();
        etdmDataId.setDataId(rs.getInt(columnIndex));
    }

    public boolean preTrans(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        Class<?> entityType = entity.getClass();
        OrmDataId etdmDataId = (OrmDataId)entity;
        boolean isInsert = false;
        if (etdmDataId.getDataId() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            etdmDataId.setDataId(newDataId);
            isInsert = true;
        }
        return isInsert;
    }

    @Override
    public int putEntity(DtsSession dtsSession, OrmPersistenceProxy persistenceProxy, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean isInsertCheck) throws Exception {
        int updateCount;
        block13: {
            SqlContext sqlContext = dtsSession.getSqlContext();
            Class<?> entityType = entity.getClass();
            OrmDataId etdmDataId = (OrmDataId)entity;
            boolean isInsert = false;
            isInsert = isInsertCheck ? this.preTrans(dtsSession, tableName, entity) : true;
            SqlUpdateQuery updateQuery = new SqlUpdateQuery();
            updateQuery.tableName = tableName;
            persistenceProxy.createCommonSetPhrase(updateQuery, entity);
            int i = 0;
            while (i < columnList.size()) {
                Object value = valueList.get(i);
                SqlSetClause setClause = new SqlSetClause(columnList.get(i), value);
                updateQuery.addSetClause(setClause);
                ++i;
            }
            updateCount = 0;
            if (isInsert) {
                String sql = sqlContext.buildInsertQuery(updateQuery);
                try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                    try {
                        updateCount = stmt.executeUpdate(sql);
                        break block13;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error("error:sql=" + sql);
                        throw ex;
                    }
                }
            }
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id=" + etdmDataId.getDataId());
            updateQuery.getWhereElementList().add(whereElement);
            String sql = sqlContext.buildUpdateQuery(updateQuery);
            try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                try {
                    updateCount = stmt.executeUpdate(sql);
                    if (updateCount <= 0) {
                        sql = sqlContext.buildInsertQuery(updateQuery);
                        updateCount = stmt.executeUpdate(sql);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.debug("error:sql=" + sql);
                    throw ex;
                }
            }
        }
        return updateCount;
    }
}

