/*
 * Decompiled with CFR 0.152.
 */
package ext.base.event;

import ext.base.event.BcEvent;
import ext.base.event.BcEventHandler;
import ext.base.log.BcLoggableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BcEventHandlerList
extends BcLoggableObject {
    private List<BcEventHandler> list = Collections.synchronizedList(new ArrayList());

    public boolean addEventHandler(BcEventHandler eventHandler) throws Exception {
        return this.list.add(eventHandler);
    }

    public boolean removeEventHandler(BcEventHandler eventHandler) throws Exception {
        this.getLogger().debug("removeEventHandler:eventHandler" + eventHandler);
        return this.list.remove(eventHandler);
    }

    public void fireEvent(BcEvent event) throws Exception {
        this.getLogger().debug("fireEvent:event=" + event);
        BcEventHandler[] eventHandlers = this.list.toArray(new BcEventHandler[this.list.size()]);
        this.getLogger().debug("eventHandlers.length=" + eventHandlers.length);
        int i = 0;
        while (i < eventHandlers.length) {
            try {
                BcEventHandler eventHandler = eventHandlers[i];
                eventHandler.handle(event);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }
}

