/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.util.CollectionUtils;

public class Resources
extends DataType
implements ResourceCollection {
    public static final ResourceCollection NONE = new ResourceCollection(){

        @Override
        public boolean isFilesystemOnly() {
            return true;
        }

        @Override
        public Iterator<Resource> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }
    };
    public static final Iterator<Resource> EMPTY_ITERATOR = new Iterator<Resource>(){

        @Override
        public Resource next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private Vector<ResourceCollection> rc;
    private Collection<Resource> coll;
    private boolean cache = false;

    public Resources() {
    }

    public Resources(Project project) {
        this.setProject(project);
    }

    public synchronized void setCache(boolean b) {
        this.cache = b;
    }

    public synchronized void add(ResourceCollection c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        if (this.rc == null) {
            this.rc = new Vector();
        }
        this.rc.add(c);
        this.invalidateExistingIterators();
        this.coll = null;
        this.setChecked(false);
    }

    @Override
    public synchronized Iterator<Resource> iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.validate();
        return new FailFast(this, this.coll.iterator());
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.validate();
        return this.coll.size();
    }

    @Override
    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return this.getRef().isFilesystemOnly();
        }
        this.validate();
        Iterator<ResourceCollection> i = this.getNested().iterator();
        while (i.hasNext()) {
            if (i.next().isFilesystemOnly()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        this.validate();
        if (this.coll == null || this.coll.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Resource r : this.coll) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(r);
        }
        return sb.toString();
    }

    @Override
    protected void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (ResourceCollection resourceCollection : this.getNested()) {
                if (!(resourceCollection instanceof DataType)) continue;
                Resources.pushAndInvokeCircularReferenceCheck((DataType)((Object)resourceCollection), stk, p);
            }
            this.setChecked(true);
        }
    }

    protected void invalidateExistingIterators() {
        FailFast.invalidate(this);
    }

    private ResourceCollection getRef() {
        return this.getCheckedRef(ResourceCollection.class, "ResourceCollection");
    }

    private synchronized void validate() {
        this.dieOnCircularReference();
        this.coll = this.coll == null ? new MyCollection() : this.coll;
    }

    private synchronized List<ResourceCollection> getNested() {
        return this.rc == null ? Collections.emptyList() : this.rc;
    }

    private class MyCollection
    extends AbstractCollection<Resource> {
        private Collection<Resource> cached;

        MyCollection() {
        }

        @Override
        public int size() {
            return this.getCache().size();
        }

        @Override
        public Iterator<Resource> iterator() {
            return this.getCache().iterator();
        }

        private synchronized Collection<Resource> getCache() {
            Collection<Resource> coll = this.cached;
            if (coll == null) {
                coll = CollectionUtils.asCollection(new MyIterator());
                if (Resources.this.cache) {
                    this.cached = coll;
                }
            }
            return coll;
        }

        private class MyIterator
        implements Iterator<Resource> {
            private Iterator<ResourceCollection> rci;
            private Iterator<Resource> ri;

            private MyIterator() {
                this.rci = Resources.this.getNested().iterator();
                this.ri = null;
            }

            @Override
            public boolean hasNext() {
                boolean result = this.ri != null && this.ri.hasNext();
                while (!result && this.rci.hasNext()) {
                    this.ri = this.rci.next().iterator();
                    result = this.ri.hasNext();
                }
                return result;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.ri.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

