/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.util.FileUtils;

public class StreamPumper
implements Runnable {
    private static final int SMALL_BUFFER_SIZE = 128;
    private final InputStream is;
    private final OutputStream os;
    private volatile boolean finish;
    private volatile boolean finished;
    private final boolean closeWhenExhausted;
    private boolean autoflush = false;
    private Exception exception = null;
    private int bufferSize = 128;
    private boolean started = false;
    private final boolean useAvailable;
    private static final long POLL_INTERVAL = 100L;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this(is, os, closeWhenExhausted, false);
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, boolean useAvailable) {
        this.is = is;
        this.os = os;
        this.closeWhenExhausted = closeWhenExhausted;
        this.useAvailable = useAvailable;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block29: {
            block31: {
                StreamPumper streamPumper = this;
                synchronized (streamPumper) {
                    this.started = true;
                }
                this.finished = false;
                byte[] buf = new byte[this.bufferSize];
                try {
                    int length;
                    do {
                        this.waitForInput(this.is);
                        if (this.finish || Thread.interrupted() || (length = this.is.read(buf)) <= 0 || Thread.interrupted()) break;
                        this.os.write(buf, 0, length);
                        if (!this.autoflush) continue;
                        this.os.flush();
                    } while (!this.finish);
                    if (this.finish) {
                        while ((length = this.is.available()) > 0) {
                            if (Thread.interrupted() || (length = this.is.read(buf, 0, Math.min(length, buf.length))) <= 0) break;
                            this.os.write(buf, 0, length);
                        }
                    }
                    this.os.flush();
                }
                catch (InterruptedException interruptedException) {
                    if (this.closeWhenExhausted) {
                        FileUtils.close(this.os);
                    }
                    this.finished = true;
                    this.finish = false;
                    StreamPumper streamPumper2 = this;
                    synchronized (streamPumper2) {
                        this.notifyAll();
                        break block29;
                    }
                }
                catch (Exception e) {
                    block30: {
                        try {
                            StreamPumper streamPumper3 = this;
                            synchronized (streamPumper3) {
                                this.exception = e;
                            }
                            if (!this.closeWhenExhausted) break block30;
                        }
                        catch (Throwable throwable) {
                            if (this.closeWhenExhausted) {
                                FileUtils.close(this.os);
                            }
                            this.finished = true;
                            this.finish = false;
                            StreamPumper streamPumper4 = this;
                            synchronized (streamPumper4) {
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        FileUtils.close(this.os);
                    }
                    this.finished = true;
                    this.finish = false;
                    StreamPumper streamPumper5 = this;
                    synchronized (streamPumper5) {
                        this.notifyAll();
                        break block29;
                    }
                }
                if (!this.closeWhenExhausted) break block31;
                FileUtils.close(this.os);
            }
            this.finished = true;
            this.finish = false;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.notifyAll();
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    synchronized void stop() {
        this.finish = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInput(InputStream is) throws IOException, InterruptedException {
        if (this.useAvailable) {
            while (!this.finish && is.available() == 0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                StreamPumper streamPumper = this;
                synchronized (streamPumper) {
                    this.wait(100L);
                }
            }
        }
    }
}

