/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.swg;

import ext.base.core.BcStringUtil;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTabbedPane;
import ext.lib.swg.SwgUtil;
import ext.scf5.swg.IswgLoadableTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class IswgAbstractDataViewPanel
extends SwgBorderPanel {
    private static final long serialVersionUID = -7752436416137906779L;
    protected JSplitPane splitPane = new JSplitPane();
    public JPanel headerPanel = new JPanel();
    protected JPanel conditionControlPanel = new JPanel();
    protected SwgPanel conditionBasePanel = new SwgPanel();
    protected SwgButton executeButton;
    protected SwgBorderPanel contentPanel = new SwgBorderPanel();
    protected JTabbedPane tabbedPane;
    protected int tabCount;
    protected DataViewStyle dataViewStyle;
    protected Window window;
    private String title;
    protected Map<Integer, Component> contentMap = new HashMap<Integer, Component>();
    protected double ratio = 0.8;

    public IswgAbstractDataViewPanel(DataViewStyle dataViewStyle) throws Exception {
        this.dataViewStyle = dataViewStyle;
    }

    public void init() throws Exception {
        this.setBorderSize(0, 0, 0, 0);
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerSize(2);
        this.headerPanel.setLayout(new BorderLayout());
        switch (this.dataViewStyle) {
            case Default: {
                this.conditionControlPanel.setPreferredSize(new Dimension(100, 40));
                this.headerPanel.add("East", this.conditionControlPanel);
                break;
            }
            default: {
                this.headerPanel.add("South", this.conditionControlPanel);
                FlowLayout flowLayout = new FlowLayout();
                flowLayout.setVgap(0);
                this.conditionControlPanel.setLayout(flowLayout);
            }
        }
        if (!BcStringUtil.isEmpty(this.getConditionTitle())) {
            this.conditionBasePanel.setBorderTitle(this.getConditionTitle());
        }
        Component conditionComponent = this.createConditionComponent(-1, null);
        this.setConditonComponent(conditionComponent);
        this.optionControlSetup(this.conditionControlPanel);
        this.headerPanel.add("Center", this.conditionBasePanel);
        this.splitPane.add((Component)this.headerPanel, "top");
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.splitPane, "Center");
        this.contentPanel.setBorderSize(2, 2, 2, 2);
        this.contentPanel.centerPanel.setLayout(new BorderLayout());
        this.splitPane.add((Component)this.contentPanel, "bottom");
        this.splitPane.setDividerLocation(this.getDividerLocation());
        this.tabbedPane = this.createTabbedPane();
        this.contentPanel.centerPanel.add("Center", this.tabbedPane);
    }

    public int getDividerLocation() throws Exception {
        return 240;
    }

    public Component getConditonComponent() throws Exception {
        BorderLayout borderLayout = (BorderLayout)this.conditionBasePanel.getLayout();
        return borderLayout.getLayoutComponent("Center");
    }

    public void setConditonComponent(Component conditonComponent) throws Exception {
        this.conditionBasePanel.removeAll();
        this.conditionBasePanel.setLayout(new BorderLayout());
        this.conditionBasePanel.add("Center", conditonComponent);
        this.conditionBasePanel.validate();
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.executeButton) {
            BcResult result = this.validateCondition();
            if (result.hasError()) {
                Component messageComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                SwgOptionPane.showMessageDialog(this, messageComponent, BcWords.getInstance().error, 0);
            } else {
                this.doSearch();
            }
        }
    }

    protected BcResult validateCondition() throws Exception {
        return new BcResult();
    }

    protected JTabbedPane createTabbedPane() throws Exception {
        SwgTabbedPane tabbedPane = new SwgTabbedPane(1);
        tabbedPane.closeIconEnabled(true);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                int index = sourceTabbedPane.getSelectedIndex();
                Component component = sourceTabbedPane.getSelectedComponent();
                try {
                    IswgAbstractDataViewPanel.this.tabSelected(index, component);
                }
                catch (Exception ex) {
                    IswgAbstractDataViewPanel.this.handleException(ex);
                }
            }
        };
        tabbedPane.addChangeListener(changeListener);
        this.contentPanel.centerPanel.add("Center", tabbedPane);
        return tabbedPane;
    }

    protected void addTad(Component contentComponent) throws Exception {
        Component conditonComponent = this.getConditonComponent();
        this.contentMap.put(contentComponent.hashCode(), conditonComponent);
        ++this.tabCount;
        this.tabbedPane.addTab(String.valueOf(BcWords.getInstance().result) + this.tabCount, contentComponent);
        this.tabbedPane.setSelectedComponent(contentComponent);
    }

    protected void tabSelected(int tabIndex, Component contentComponent) throws Exception {
        Component conditionComponent = this.contentMap.get(contentComponent.hashCode());
        Component newConditionComponent = this.createConditionComponent(tabIndex, conditionComponent);
        this.setConditonComponent(newConditionComponent);
    }

    protected abstract Component createConditionComponent(int var1, Component var2) throws Exception;

    public void setHeaderDisable() throws Exception {
        this.headerPanel.removeAll();
        this.splitPane.setDividerLocation(0);
    }

    protected String getConditionTitle() throws Exception {
        return BcWords.getInstance().extractionCondition.toPlain();
    }

    public IswgLoadableTablePanel createTablePanel() throws Exception {
        IswgLoadableTablePanel tablePanel = new IswgLoadableTablePanel();
        tablePanel.setLocal(true);
        return tablePanel;
    }

    protected String getTitle() throws Exception {
        return this.title;
    }

    public void setTitle(String title) throws Exception {
        this.title = title;
    }

    protected void optionControlSetup(JPanel conditionControlPanel) throws Exception {
        this.executeButton = SwgUtil.cretaeExecuteButton();
        this.executeButton.addActionListener(this.actionListener);
        conditionControlPanel.add(this.executeButton);
    }

    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("document_64x64.png");
    }

    public void doSearch() throws Exception {
        RmiRequest rmiReq = this.createRequest();
        IswgLoadableTablePanel tablePanel = this.createTablePanel();
        this.addTad(tablePanel);
        tablePanel.doLoad(rmiReq);
    }

    protected abstract RmiRequest createRequest() throws Exception;

    protected void windowOpened(WindowEvent ev) throws Exception {
    }

    protected void windowClosing(WindowEvent ev) throws Exception {
        this.close();
    }

    @Override
    public void close() throws Exception {
        super.close();
        int i = 0;
        while (i < this.tabbedPane.getComponentCount()) {
            Component component = this.tabbedPane.getComponent(i);
            if (component instanceof AutoCloseable) {
                AutoCloseable autoCloseable = (AutoCloseable)((Object)component);
                autoCloseable.close();
            }
            ++i;
        }
        this.window.dispose();
    }

    protected void showAsFrame2() throws Exception {
        if (this.window != null) {
            this.window.toFront();
            return;
        }
        SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                try {
                    IswgAbstractDataViewPanel.this.windowOpened(ev);
                }
                catch (Exception ex) {
                    IswgAbstractDataViewPanel.this.handleException(ex);
                }
            }

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    IswgAbstractDataViewPanel.this.windowClosing(ev);
                }
                catch (Exception ex) {
                    IswgAbstractDataViewPanel.this.handleException(ex);
                }
            }
        });
        this.window = frame;
        this.setFrameOption(frame);
        this.window.setVisible(true);
    }

    public void setFrameOption(JFrame frame) throws Exception {
        frame.setTitle(this.getTitle());
        Image image = this.getIconImage();
        frame.setIconImage(image);
    }

    public void showAsFrame() throws Exception {
        this.showAsFrame2();
        SwgUtil.setCascadeRectangle(this.window, this, this.ratio);
    }

    public void showAsFrame(int baseX, int baseY) throws Exception {
        this.showAsFrame2();
        SwgUtil.setCascadeRectangle(this.window, baseX, baseY, this.ratio);
    }

    public void showAsFrame(Component baseCompo) throws Exception {
        this.showAsFrame2();
        SwgUtil.setCascadeRectangle(this.window, baseCompo, this.ratio);
    }

    public static enum DataViewStyle {
        Default,
        Old;

    }
}

