/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.table.BcTableColumnModel;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.libx.fx.FxxAbstractDesktopPane;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.fx.XfilFileTablePane;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilUriEntity;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XfilResultPane
extends FxxAbstractDesktopPane {
    SplitPane splitPane1 = new SplitPane();
    FxTabPane tabPane1 = new FxTabPane();
    SplitPane splitPane2 = new SplitPane();
    FxBorderPane borderPane1 = new FxBorderPane();
    protected Button executeButton;
    protected Button cancelButton;
    protected Button selectAllButton;
    protected Button notSelectAllButton;
    protected Stage stage;
    XfilAnalysisResult analysisResult;

    public XfilResultPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.splitPane2.setOrientation(Orientation.HORIZONTAL);
        this.splitPane1.getItems().addAll((Object[])new Node[]{this.tabPane1, this.splitPane2});
        this.splitPane1.setDividerPositions(new double[]{0.2f, 0.8f});
        this.splitPane2.setOrientation(Orientation.VERTICAL);
        this.splitPane2.getItems().addAll((Object[])new Node[]{this.borderPane1});
        this.splitPane1.setDividerPositions(new double[]{0.7f, 0.3f});
        this.setCenter((Node)this.splitPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    public void addTab(Node node, int index) throws Exception {
        Tab tab = new Tab();
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent(node);
        tab.closableProperty().set(false);
        if (index < 0) {
            this.tabPane1.getTabs().add((Object)tab);
            this.tabPane1.getSelectionModel().select((Object)tab);
        } else {
            this.tabPane1.getTabs().add(index, (Object)tab);
        }
    }

    public void setData(XfilAnalysisResult analysisResult) throws Exception {
        this.analysisResult = analysisResult;
        ObservableList tableItems = FXCollections.observableArrayList();
        Set<Map.Entry<String, List<XfilUriEntity>>> entrySet = analysisResult.uriEntityMap.entrySet();
        for (Map.Entry<String, List<XfilUriEntity>> mapEntry : entrySet) {
            List<XfilUriEntity> uriEntityList = mapEntry.getValue();
            XfilUriEntity uriEntity = uriEntityList.get(0);
            uriEntity.childCount = uriEntityList.size();
            tableItems.add((Object)uriEntity);
        }
        BcTableColumnModel tableColumnModel = XfilUtil.createTableColumnModel_2();
        InnerFileTablePane1 fileTablePane = new InnerFileTablePane1();
        fileTablePane.setData(tableItems, 2);
        this.addTab((Node)fileTablePane, 0);
    }

    protected void setKey(String key) throws Exception {
        List<XfilUriEntity> uriEntityList = this.analysisResult.uriEntityMap.get(key);
        ObservableList tableItems = FXCollections.observableArrayList();
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = uriEntityList.get(i);
            tableItems.add((Object)uriEntity);
            ++i;
        }
        BcTableColumnModel tableColumnModel = XfilUtil.createTableColumnModel_1();
        InnerFileTablePane2 fileTablePane = new InnerFileTablePane2();
        fileTablePane.setData(tableItems, 1);
        this.borderPane1.setCenter((Node)fileTablePane);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public boolean show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.init();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        this.stage.setTitle("\u540c\u3058\u30d5\u30a1\u30a4\u30eb\uff01");
        this.stage.show();
        return false;
    }

    class InnerFileTablePane1
    extends XfilFileTablePane {
        @Override
        protected void rowSelectionChanged(Number prevRowIndex, Number nextRowIndex) throws Exception {
            super.rowSelectionChanged(prevRowIndex, nextRowIndex);
            XfilUriEntity uriEntity = this.getlUriEntity(nextRowIndex.intValue());
            XfilResultPane.this.setKey(XfilUtil.createKey(uriEntity));
        }
    }

    class InnerFileTablePane2
    extends XfilFileTablePane {
        @Override
        protected void rowSelectionChanged(Number prevRowIndex, Number nextRowIndex) throws Exception {
            super.rowSelectionChanged(prevRowIndex, nextRowIndex);
        }
    }
}

