/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.science;

import ext.base.util.BcMessageCreator;

public final class NuclideUtil {
    public static final String UNIT_Y = "Y";
    public static final String UNIT_M = "M";
    public static final String UNIT_D = "D";
    public static final String UNIT_H = "H";
    public static final String UNIT_S = "S";
    public static final String[] units = new String[]{"Y", "M", "D", "H", "S"};
    public static final double yearDays = 365.0;
    public static final double monthDays = 30.4;
    public static final double hours = 24.0;
    public static final String MSG_\u534a\u6e1b\u671f\u5358\u4f4d_0_\u306f\u672a\u5bfe\u5fdc\u3067\u3059 = "\u534a\u6e1b\u671f\u5358\u4f4d {0} \u306f\u672a\u5bfe\u5fdc\u3067\u3059\u3002";

    private NuclideUtil() {
    }

    public static double calcAttenuationValue(double halfLife, String unit, double quantity, double dayCount) throws Exception {
        double value = 0.0;
        double df = dayCount * -1.0;
        if (UNIT_Y.equals(unit)) {
            value = quantity * Math.pow(2.0, df / 365.0 / halfLife);
        } else if (UNIT_M.equals(unit)) {
            value = quantity * Math.pow(2.0, df / 30.4 / halfLife);
        } else if (UNIT_D.equals(unit)) {
            value = quantity * Math.pow(2.0, df / halfLife);
        } else if (UNIT_H.equals(unit)) {
            value = quantity * Math.pow(2.0, df * 24.0 / halfLife);
        } else {
            String msg = BcMessageCreator.getInstance().bindMessage(MSG_\u534a\u6e1b\u671f\u5358\u4f4d_0_\u306f\u672a\u5bfe\u5fdc\u3067\u3059, unit);
            throw new Exception(msg);
        }
        return value;
    }

    public static double calcAttenuationValue(double halfLifeN, int halfLifeE, String unit, double quantity, double dayCount) throws Exception {
        double halfLife = halfLifeN * Math.pow(10.0, halfLifeE);
        return NuclideUtil.calcAttenuationValue(halfLife, unit, quantity, dayCount);
    }
}

