/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sourceparser;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcEncoder;
import ext.lib.sourceparser.JspAbstractVisitor;
import java.io.File;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JspSourceParser {
    protected ASTVisitor astVisitor;

    public void parse(File sourceFile) throws Exception {
        BcLogUtil.debug("sourceFile=" + sourceFile.getPath());
        String charsetName = BcEncoder.detectEncoding(sourceFile);
        BcLogUtil.debug("charsetName=" + charsetName);
        if (BcStringUtil.isEmpty(charsetName)) {
            charsetName = "UTF-8";
        }
        Charset charset = Charset.forName(charsetName);
        StringBuilder sb = BcFileUtil.readAsStringBuilder(sourceFile, charset);
        char[] source = sb.toString().toCharArray();
        ASTParser astParser = ASTParser.newParser((int)3);
        astParser.setSource(sb.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)astParser.createAST((IProgressMonitor)new NullProgressMonitor());
        if (this.astVisitor instanceof JspAbstractVisitor) {
            JspAbstractVisitor abstractVisitor = (JspAbstractVisitor)this.astVisitor;
            abstractVisitor.setSource(source);
        }
        compilationUnit.accept(this.astVisitor);
    }

    public void setVisitor(ASTVisitor astVisitor) {
        this.astVisitor = astVisitor;
    }
}

