/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.rmi.connector;

import ext.base.log.BcLogUtil;
import ext.base.thread.BcThread;
import ext.lib.rmi.common.RmiConnectionEventHandler;
import ext.lib.rmi.common.RmiDataRecieveEventHandler;
import ext.lib.rmi.connector.RmiConnector;
import ext.lib.rmi.model.RmiNetConfig;
import ext.lib.rmi.model.RmiPacket;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public class RmiObjectStreamConnector
extends BcThread
implements RmiConnector {
    private RmiConnectionEventHandler connectionEventListener;
    private RmiDataRecieveEventHandler dataRecieveEventHandler;
    private Socket socket;
    private ObjectOutputStream os;
    private ObjectInputStream is;
    private RmiNetConfig netConfig;
    private Map<Long, RmiRespons> responsMap;
    private long requestId = 0L;

    public void setNetConfig(RmiNetConfig netConfig) {
        this.netConfig = netConfig;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) throws Exception {
        this.socket = socket;
        this.responsMap = new HashMap<Long, RmiRespons>();
        this.os = new ObjectOutputStream(socket.getOutputStream());
        this.os.flush();
        this.startThread();
    }

    @Override
    public boolean isOpen() throws Exception {
        if (this.socket != null) {
            return !this.socket.isClosed();
        }
        return false;
    }

    public ObjectInputStream getInputStream() throws Exception {
        if (this.is != null) {
            return this.is;
        }
        this.is = new ObjectInputStream(this.socket.getInputStream());
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(Object object) throws Exception {
        ObjectOutputStream objectOutputStream = this.os;
        synchronized (objectOutputStream) {
            try {
                try {
                    this.os.writeObject(object);
                    this.os.flush();
                }
                catch (ObjectStreamException ex) {
                    throw ex;
                }
                catch (SocketException ex) {
                    this.close(this);
                    throw ex;
                }
                catch (IOException ex) {
                    this.close(this);
                    throw ex;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
            finally {
                this.os.reset();
            }
        }
    }

    @Override
    protected void run2() throws Exception {
        try {
            this.recieve();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.close(this);
        }
    }

    protected void recieve() throws Exception {
        try {
            Object resObj = this.getInputStream().readObject();
            this.dataRecieved(resObj);
        }
        catch (InvalidClassException ex) {
            BcLogUtil.error(ex);
            this.stop();
        }
        catch (ObjectStreamException ex) {
            BcLogUtil.error(ex);
            try {
                this.getInputStream().skip(this.getInputStream().available());
            }
            catch (Exception ex2) {
                BcLogUtil.error(ex2);
            }
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (EOFException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    @Override
    public void close(Object operator) throws Exception {
        this.stopThread();
        if (this.os != null) {
            try {
                this.os.close();
                this.os = null;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
                this.is = null;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (this.dataRecieveEventHandler != null) {
            this.dataRecieveEventHandler = null;
        }
        if (this.responsMap != null) {
            this.responsMap.clear();
            this.responsMap = null;
        }
        if (this.connectionEventListener != null) {
            try {
                this.connectionEventListener.disconnected(this, operator);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    @Override
    public void setConnectionEventListener(RmiConnectionEventHandler connectionEventListener) throws Exception {
        this.connectionEventListener = connectionEventListener;
    }

    @Override
    public void setDataRecieveEventHandler(RmiDataRecieveEventHandler dataRecieveEventHandler) throws Exception {
        this.dataRecieveEventHandler = dataRecieveEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RmiRespons sendRequest(RmiRequest rmiReq) throws Exception {
        RmiObjectStreamConnector rmiObjectStreamConnector = this;
        synchronized (rmiObjectStreamConnector) {
            ++this.requestId;
            if (this.requestId >= Integer.MAX_VALUE) {
                throw new Exception("requestId=" + this.requestId);
            }
        }
        rmiReq.setId(this.requestId);
        RmiRespons rmiRes = this.sendRequest2(rmiReq);
        return rmiRes;
    }

    protected RmiRespons sendRequest2(RmiRequest rmiReq) throws Exception {
        this.sendData(rmiReq);
        Thread.sleep(this.netConfig.recieveFirstWaitMillis);
        int retryCnt = 0;
        RmiRespons rmiRes;
        while ((rmiRes = this.responsMap.remove(rmiReq.getId())) == null) {
            if (++retryCnt % 100 == 0) {
                BcLogUtil.warning("sendRequest2:retryCnt=" + retryCnt + " rmiReq.id=" + rmiReq.getId() + " Method=" + rmiReq.getClassName() + "." + rmiReq.getMethodName());
            }
            Thread.sleep(this.netConfig.recieveRetryIntervalMillis);
        }
        return rmiRes;
    }

    protected void dataRecieved(Object data) throws Exception {
        if (data instanceof RmiPacket) {
            RmiPacket rmixPacket = (RmiPacket)data;
            if (rmixPacket.getPacketType() == 11) {
                if (this.dataRecieveEventHandler != null) {
                    this.dataRecieveEventHandler.dataRecieved(rmixPacket);
                }
            } else if (rmixPacket.getPacketType() == 13) {
                if (this.dataRecieveEventHandler != null) {
                    this.dataRecieveEventHandler.dataRecieved(rmixPacket);
                }
            } else if (rmixPacket.getPacketType() == 12) {
                RmiRespons rmiRes = (RmiRespons)rmixPacket;
                this.responsMap.put(rmiRes.getRequestId(), rmiRes);
            } else {
                BcLogUtil.warning("Unknown packet type:" + rmixPacket.getPacketType());
            }
        } else {
            BcLogUtil.warning("Unknown data type:data=" + data);
        }
    }

    @Override
    public void sendRespons(RmiRespons rmiRes) throws Exception {
        if (!this.isOpen()) {
            throw new Exception("closed.");
        }
        this.sendData(rmiRes);
    }
}

