/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.editor;

import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.lib.doc.editor.DcfEditorMainPane;
import ext.lib.doc.script.DcfScriptParser;
import ext.lib.swg.SwgControlPanel;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nlc.lib.doc.DcfPage;

public class DcfEditorControlPanel
extends SwgPanel
implements ItemListener {
    private static final long serialVersionUID = 8018631611583305959L;
    DcfScriptParser dcfScriptParser = new DcfScriptParser();
    protected boolean isEdited;
    public static final String SIZE_A4T = "A4 \u7e26";
    public static final String SIZE_A4Y = "A4 \u6a2a";
    SwgControlPanel controlPanel;
    JPanel southPanel;
    DcfEditorMainPane mainPane;
    JPanel propertyPanel = new JPanel();
    JLabel statusJLabel = new JLabel();
    SwgTextField pointField = new SwgTextField();
    JComboBox paperSizeCombo;
    public JButton columnSelectButton = new JButton("\u25bc");
    protected DcfPage dcfPage;

    public DcfEditorControlPanel() throws Exception {
        this.controlPanel = new SwgControlPanel();
        this.propertyPanel.setLayout(new GridLayout());
        this.controlPanel.add((Component)new JLabel("\u7528\u7d19\u30b5\u30a4\u30ba"), -1);
        this.paperSizeCombo = new JComboBox();
        this.paperSizeCombo.addItem(SIZE_A4T);
        this.paperSizeCombo.addItem(SIZE_A4Y);
        this.paperSizeCombo.addItemListener(this);
        this.controlPanel.add(this.paperSizeCombo);
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new GridLayout());
        this.pointField.setEditable(false);
        this.pointField.setBackground(Color.lightGray);
        this.southPanel.add(this.pointField);
        this.statusJLabel.setBackground(Color.lightGray);
        this.southPanel.add(this.statusJLabel);
        this.mainPane = new DcfEditorMainPane(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.southPanel, "South");
        this.add((Component)new JScrollPane(this.mainPane), "Center");
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        try {
            this.itemStateChanged2(ev);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void itemStateChanged2(ItemEvent ev) throws Exception {
        if (ev.getSource() == this.paperSizeCombo) {
            if (ev.getStateChange() != 1) {
                return;
            }
            if (this.dcfPage == null) {
                return;
            }
            String sizeName = (String)this.paperSizeCombo.getSelectedItem();
            this.mainPane.drawAllElement();
            this.mainPane.repaint();
            this.isEdited = true;
        }
    }

    public void setDefineScript(String script, BcMonitor paMonitor) throws Exception {
        if (paMonitor != null) {
            paMonitor.lock();
        }
        if (script == null) {
            throw new Exception("script is null");
        }
        this.setEdited(false);
        this.mainPane.initValue();
        this.dcfPage = this.dcfScriptParser.toPage(script);
        this.mainPane.calcSectionLocation();
        this.repaint();
        if (paMonitor != null) {
            paMonitor.unLock();
        }
    }

    public void setPage(DcfPage dcfPage) {
        this.dcfPage = dcfPage;
        this.mainPane.repaint();
    }

    public DcfPage getPage() {
        return this.dcfPage;
    }

    public DcfEditorMainPane getMainPane() {
        return this.mainPane;
    }

    public JPanel getPropertyPanel() {
        return this.propertyPanel;
    }

    public SwgControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void setEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public boolean isEdited() {
        return this.isEdited;
    }
}

