/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private String prompt;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String string, String[] stringArray, int n, boolean bl) {
        if (string == null || string.isEmpty() || stringArray == null || stringArray.length == 0 || n < 0 || n >= stringArray.length) {
            throw new IllegalArgumentException();
        }
        this.prompt = string;
        this.defaultChoice = n;
        this.multipleSelectionsAllowed = bl;
        this.choices = (String[])stringArray.clone();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && !stringArray[i].isEmpty()) continue;
            throw new IllegalArgumentException();
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int n) {
        this.selections = new int[1];
        this.selections[0] = n;
    }

    public void setSelectedIndexes(int[] nArray) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = nArray;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.prompt == null || this.prompt.isEmpty() || this.choices == null || this.choices.length == 0 || this.defaultChoice < 0 || this.defaultChoice >= this.choices.length) {
            throw new InvalidObjectException("Missing/invalid prompt/choices");
        }
        this.choices = (String[])this.choices.clone();
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i] != null && !this.choices[i].isEmpty()) continue;
            throw new InvalidObjectException("Null/empty choices");
        }
        if (this.selections != null) {
            this.selections = (int[])this.selections.clone();
            if (!this.multipleSelectionsAllowed && this.selections.length != 1) {
                throw new InvalidObjectException("Multiple selections not allowed");
            }
        }
    }
}

