/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.lib.fx.control.FxTextField;
import java.util.Calendar;
import javafx.geometry.Pos;

public class FxTimeField
extends FxTextField {
    protected Calendar calendar;
    protected String format;
    protected int mode;

    public FxTimeField() throws Exception {
        this.setPrefColumnCount(10);
        this.setAlignment(Pos.CENTER);
        this.mode = 3;
        this.setFormat("HH:mm:ss");
    }

    @Override
    public void textEdited() {
        this.calendar = null;
        if (BcStringUtil.isEmpty(this.getText())) {
            super.setText(null);
            return;
        }
        try {
            this.calendar = BcTimeUtil.toCalendar(this.getText(), this.format);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.calendar != null) {
            this.setText(BcTimeUtil.toString(this.calendar, this.format));
        } else {
            this.setText("");
        }
    }

    public void setCalendar(Calendar calendar) throws Exception {
        this.calendar = calendar;
        int HHmmss = BcTimeUtil.toHHmmss(calendar);
        this.setText(BcTimeUtil.toString(calendar, this.format));
    }

    public int getHHmmss() throws Exception {
        int HHmmss = BcTimeUtil.toHHmmss(this.calendar);
        return HHmmss;
    }

    public void setHHmmss(int HHmmss) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setTimeField(calendar, HHmmss);
        this.setCalendar(calendar);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws Exception {
        this.format = format;
        this.setPrefColumnCount(format.length());
    }
}

