/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.rmi.client;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.net.BcAddressPort;
import ext.base.thread.BcThread;
import ext.base.util.BcWords;
import ext.lib.awt.AwtUtil;
import ext.lib.rmi.client.RmiAgentNet;
import ext.lib.rmi.client.RmiAgentNetThread_v100;
import ext.lib.rmi.model.RmiNetConfig;
import ext.scf.swg.EswgCennectMonitorPanel;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.ServerException;
import javax.swing.JOptionPane;

public class RmiAgentNetThread
extends BcThread {
    private BcLogger logger;
    protected RmiAgentNet rmiAgentNet;
    protected RmiNetConfig rmiNetConfig;
    private int addressRowId = -1;
    private EswgCennectMonitorPanel cennectMonitorPanel;

    public RmiAgentNetThread(RmiAgentNet rmiAgentNet) throws Exception {
        this.rmiAgentNet = rmiAgentNet;
        this.rmiNetConfig = rmiAgentNet.getNetConfig();
        this.setPriority(1);
        this.setLogger(BcLogUtil.getDefaultLogger());
    }

    @Override
    public BcLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(BcLogger logger) {
        this.logger = logger;
    }

    @Override
    protected void run2() throws Exception {
        this.logger.debug("rmiNetConfig.currentRemoteHostAddressPort=" + this.rmiNetConfig.currentRemoteHostAddressPort);
        boolean doRetry = true;
        if (this.rmiNetConfig.currentRemoteHostAddressPort == null) {
            ++this.addressRowId;
            BcAddressPort addressPort = this.findAddress();
            if (addressPort == null) {
                String msg = "\u30ea\u30e2\u30fc\u30c8\u30db\u30b9\u30c8\u5de1\u56de\u4e0a\u9650 \u306b\u9054\u3057\u307e\u3057\u305f\u3002addressRowId=" + this.addressRowId;
                this.getLogger().info(msg);
                if (AwtUtil.isGuiEnabled()) {
                    JOptionPane.showMessageDialog(null, msg, BcWords.getInstance().exception, 0);
                }
                System.exit(0);
            }
            this.rmiNetConfig.currentRemoteHostAddressPort = addressPort;
            this.logger.info(this.rmiNetConfig.currentRemoteHostAddressPort.toString());
            doRetry = false;
        }
        if (AwtUtil.isGuiEnabled()) {
            if (this.cennectMonitorPanel == null) {
                this.cennectMonitorPanel = new EswgCennectMonitorPanel();
            }
            this.cennectMonitorPanel.showAsFrame();
        }
        try {
            boolean isConnected = this.doConnectL1(doRetry);
            if (isConnected) {
                this.rmiAgentNet.setOpen(true);
                this.suspendThread();
                StringBuilder sb = new StringBuilder();
                sb.append("address=" + this.rmiNetConfig.currentRemoteHostAddressPort.address);
                sb.append(" port=" + this.rmiNetConfig.currentRemoteHostAddressPort.port);
                this.logger.info(sb + " \u3078\u306e\u63a5\u7d9a\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            } else if (!doRetry) {
                this.rmiNetConfig.currentRemoteHostAddressPort = null;
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            this.suspendThread();
        }
        if (this.cennectMonitorPanel != null) {
            this.cennectMonitorPanel.close();
        }
    }

    protected boolean doConnectL1(boolean doRetry) throws Exception {
        int tryCnt = 0;
        boolean isConnected = false;
        while (true) {
            String msg = "address=" + this.rmiNetConfig.currentRemoteHostAddressPort.address + " port=" + this.rmiNetConfig.currentRemoteHostAddressPort.port + " \u306b\u63a5\u7d9a\u4e2d\uff08" + ++tryCnt + "\uff09";
            this.getLogger().info(msg);
            if (AwtUtil.isGuiEnabled()) {
                this.cennectMonitorPanel.statusField.setText(msg);
            }
            try {
                this.doConnectL2();
                if (this.rmiAgentNet.timer != null) {
                    this.rmiAgentNet.timer.cancel();
                }
                isConnected = true;
                break;
            }
            catch (SocketException ex) {
                this.getLogger().error(ex);
                this.rmiAgentNet.close();
            }
            catch (ServerException ex) {
                this.getLogger().error(ex);
                this.rmiAgentNet.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                this.rmiAgentNet.close();
            }
            if (doRetry) {
                if (this.rmiNetConfig.connectRetryCountMax > 0 && tryCnt > this.rmiNetConfig.connectRetryCountMax) {
                    msg = "\u63a5\u7d9a\u8a66\u884c\u56de\u6570\u4e0a\u9650 \u306b\u9054\u3057\u307e\u3057\u305f\u3002";
                    this.getLogger().info(msg);
                    if (AwtUtil.isGuiEnabled()) {
                        JOptionPane.showMessageDialog(null, msg, BcWords.getInstance().exception, 0);
                    }
                    System.exit(0);
                }
                Thread.sleep(this.rmiNetConfig.connectRetryIntervalMillis);
                continue;
            }
            if (tryCnt > 1) break;
        }
        return isConnected;
    }

    protected void doConnectL2() throws Exception {
        Socket socket = new Socket(this.rmiNetConfig.currentRemoteHostAddressPort.address, this.rmiNetConfig.currentRemoteHostAddressPort.port);
        this.getLogger().debug("socket.getSoTimeout()=" + socket.getSoTimeout());
        ObjectOutputStream objos = new ObjectOutputStream(socket.getOutputStream());
        objos.writeObject("rmix_100");
        objos.flush();
        RmiAgentNetThread_v100 rmiAgentNetThread_v100 = new RmiAgentNetThread_v100(this, socket);
        rmiAgentNetThread_v100.setLogger(this.getLogger());
        rmiAgentNetThread_v100.doConnectL2();
    }

    protected BcAddressPort findAddress() throws Exception {
        if (this.addressRowId >= this.rmiNetConfig.remoteHostAddressTable.getRowCount()) {
            return null;
        }
        BcAddressPort addressPort = (BcAddressPort)this.rmiNetConfig.remoteHostAddressTable.getValueAt(this.addressRowId, 0);
        return addressPort;
    }
}

