/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class NodeTest
extends Expression {
    static final long serialVersionUID = -5736721866747906182L;
    public static final String WILD = "*";
    public static final String SUPPORTS_PRE_STRIPPING = "http://xml.apache.org/xpath/features/whitespace-pre-stripping";
    protected int m_whatToShow;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    protected String m_name;
    XNumber m_score;
    public static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    public static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    public static final XNumber SCORE_QNAME = new XNumber(0.0);
    public static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public void setWhatToShow(int what) {
        this.m_whatToShow = what;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setNamespace(String ns) {
        this.m_namespace = ns;
    }

    public String getLocalName() {
        return this.m_name == null ? "" : this.m_name;
    }

    public void setLocalName(String name) {
        this.m_name = name;
    }

    public NodeTest(int whatToShow, String namespace, String name) {
        this.initNodeTest(whatToShow, namespace, name);
    }

    public NodeTest(int whatToShow) {
        this.initNodeTest(whatToShow);
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        NodeTest nt = (NodeTest)expr;
        if (nt.m_name != null) {
            if (this.m_name == null) {
                return false;
            }
            if (!nt.m_name.equals(this.m_name)) {
                return false;
            }
        } else if (this.m_name != null) {
            return false;
        }
        if (nt.m_namespace != null) {
            if (this.m_namespace == null) {
                return false;
            }
            if (!nt.m_namespace.equals(this.m_namespace)) {
                return false;
            }
        } else if (this.m_namespace != null) {
            return false;
        }
        if (this.m_whatToShow != nt.m_whatToShow) {
            return false;
        }
        return this.m_isTotallyWild == nt.m_isTotallyWild;
    }

    public NodeTest() {
    }

    public void initNodeTest(int whatToShow) {
        this.m_whatToShow = whatToShow;
        this.calcScore();
    }

    public void initNodeTest(int whatToShow, String namespace, String name) {
        this.m_whatToShow = whatToShow;
        this.m_namespace = namespace;
        this.m_name = name;
        this.calcScore();
    }

    public XNumber getStaticScore() {
        return this.m_score;
    }

    public void setStaticScore(XNumber score) {
        this.m_score = score;
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public double getDefaultScore() {
        return this.m_score.num();
    }

    public static int getNodeTypeTest(int whatToShow) {
        if ((whatToShow & 1) != 0) {
            return 1;
        }
        if ((whatToShow & 2) != 0) {
            return 2;
        }
        if ((whatToShow & 4) != 0) {
            return 3;
        }
        if ((whatToShow & 0x100) != 0) {
            return 9;
        }
        if ((whatToShow & 0x400) != 0) {
            return 11;
        }
        if ((whatToShow & 0x1000) != 0) {
            return 13;
        }
        if ((whatToShow & 0x80) != 0) {
            return 8;
        }
        if ((whatToShow & 0x40) != 0) {
            return 7;
        }
        if ((whatToShow & 0x200) != 0) {
            return 10;
        }
        if ((whatToShow & 0x20) != 0) {
            return 6;
        }
        if ((whatToShow & 0x10) != 0) {
            return 5;
        }
        if ((whatToShow & 0x800) != 0) {
            return 12;
        }
        if ((whatToShow & 8) != 0) {
            return 4;
        }
        return 0;
    }

    public static void debugWhatToShow(int whatToShow) {
        Vector<String> v = new Vector<String>();
        if ((whatToShow & 2) != 0) {
            v.addElement("SHOW_ATTRIBUTE");
        }
        if ((whatToShow & 0x1000) != 0) {
            v.addElement("SHOW_NAMESPACE");
        }
        if ((whatToShow & 8) != 0) {
            v.addElement("SHOW_CDATA_SECTION");
        }
        if ((whatToShow & 0x80) != 0) {
            v.addElement("SHOW_COMMENT");
        }
        if ((whatToShow & 0x100) != 0) {
            v.addElement("SHOW_DOCUMENT");
        }
        if ((whatToShow & 0x400) != 0) {
            v.addElement("SHOW_DOCUMENT_FRAGMENT");
        }
        if ((whatToShow & 0x200) != 0) {
            v.addElement("SHOW_DOCUMENT_TYPE");
        }
        if ((whatToShow & 1) != 0) {
            v.addElement("SHOW_ELEMENT");
        }
        if ((whatToShow & 0x20) != 0) {
            v.addElement("SHOW_ENTITY");
        }
        if ((whatToShow & 0x10) != 0) {
            v.addElement("SHOW_ENTITY_REFERENCE");
        }
        if ((whatToShow & 0x800) != 0) {
            v.addElement("SHOW_NOTATION");
        }
        if ((whatToShow & 0x40) != 0) {
            v.addElement("SHOW_PROCESSING_INSTRUCTION");
        }
        if ((whatToShow & 4) != 0) {
            v.addElement("SHOW_TEXT");
        }
        int n = v.size();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                System.out.print(" | ");
            }
            System.out.print(v.elementAt(i));
            ++i;
        }
        if (n == 0) {
            System.out.print("empty whatToShow: " + whatToShow);
        }
        System.out.println();
    }

    private static final boolean subPartMatch(String p, String t) {
        return p == t || p != null && (t == WILD || p.equals(t));
    }

    private static final boolean subPartMatchNS(String p, String t) {
        return p == t || p != null && !(p.length() > 0 ? t != WILD && !p.equals(t) : t != null);
    }

    @Override
    public XObject execute(XPathContext xctxt, int context) throws TransformerException {
        DTM dtm = xctxt.getDTM(context);
        short nodeType = dtm.getNodeType(context);
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << nodeType - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getLocalName(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    @Override
    public XObject execute(XPathContext xctxt, int context, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << dtm.getNodeType(context) - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getLocalName(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    @Override
    public void fixupVariables(Vector vars, int globalsSize) {
    }

    @Override
    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        this.assertion(false, "callVisitors should not be called for this object!!!");
    }
}

