/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.AbstractList;
import org.apache.xerces.xs.StringList;

final class PSVIErrorList
extends AbstractList
implements StringList {
    private final String[] fArray;
    private final int fLength;
    private final int fOffset;

    public PSVIErrorList(String[] array, boolean even) {
        this.fArray = array;
        this.fLength = this.fArray.length >> 1;
        this.fOffset = even ? 0 : 1;
    }

    @Override
    public boolean contains(String item) {
        if (item == null) {
            int i = 0;
            while (i < this.fLength) {
                if (this.fArray[(i << 1) + this.fOffset] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fLength) {
                if (item.equals(this.fArray[(i << 1) + this.fOffset])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public String item(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[(index << 1) + this.fOffset];
    }

    public Object get(int index) {
        if (index >= 0 && index < this.fLength) {
            return this.fArray[(index << 1) + this.fOffset];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }
}

