/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.util.GregorianCalendar;
import org.apache.log.output.io.rotate.RotateStrategy;

public class RotateStrategyByTimeOfDay
implements RotateStrategy {
    private static final long TIME_24_HOURS = 86400000L;
    private long m_currentRotation;

    public RotateStrategyByTimeOfDay() {
        this(0L);
    }

    public RotateStrategyByTimeOfDay(long time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        this.m_currentRotation = cal.getTime().getTime() + time;
        if (this.m_currentRotation > System.currentTimeMillis()) {
            this.m_currentRotation -= 86400000L;
        }
    }

    @Override
    public void reset() {
        long now = System.currentTimeMillis();
        while (this.m_currentRotation + 86400000L < now) {
            this.m_currentRotation += 86400000L;
        }
    }

    @Override
    public boolean isRotationNeeded(String data, File file) {
        long now = System.currentTimeMillis();
        return this.m_currentRotation + 86400000L < now;
    }
}

