/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jxpath.JXPathAbstractFactoryException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.NamespaceResolver;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributeIterator;
import org.apache.commons.jxpath.ri.model.dom.DOMNamespaceIterator;
import org.apache.commons.jxpath.ri.model.dom.DOMNodeIterator;
import org.apache.commons.jxpath.ri.model.dom.NamespacePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNodePointer
extends NodePointer {
    private static final long serialVersionUID = -8751046933894857319L;
    private Node node;
    private Map namespaces;
    private String defaultNamespace;
    private String id;
    private NamespaceResolver localNamespaceResolver;
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

    public DOMNodePointer(Node node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public DOMNodePointer(Node node, Locale locale, String id) {
        super(null, locale);
        this.node = node;
        this.id = id;
    }

    public DOMNodePointer(NodePointer parent, Node node) {
        super(parent);
        this.node = node;
    }

    @Override
    public boolean testNode(NodeTest test) {
        return DOMNodePointer.testNode(this.node, test);
    }

    public static boolean testNode(Node node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (node.getNodeType() != 1) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            String namespaceURI = nodeNameTest.getNamespaceURI();
            boolean wildcard = nodeNameTest.isWildcard();
            String testPrefix = testName.getPrefix();
            if (wildcard && testPrefix == null) {
                return true;
            }
            if (wildcard || testName.getName().equals(DOMNodePointer.getLocalName(node))) {
                String nodeNS = DOMNodePointer.getNamespaceURI(node);
                return DOMNodePointer.equalStrings(namespaceURI, nodeNS) || nodeNS == null && DOMNodePointer.equalStrings(testPrefix, DOMNodePointer.getPrefix(node));
            }
            return false;
        }
        if (test instanceof NodeTypeTest) {
            short nodeType = node.getNodeType();
            switch (((NodeTypeTest)test).getNodeType()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return nodeType == 4 || nodeType == 3;
                }
                case 3: {
                    return nodeType == 8;
                }
                case 4: {
                    return nodeType == 7;
                }
            }
            return false;
        }
        if (test instanceof ProcessingInstructionTest && node.getNodeType() == 7) {
            String testPI = ((ProcessingInstructionTest)test).getTarget();
            String nodePI = ((ProcessingInstruction)node).getTarget();
            return testPI.equals(nodePI);
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        s1 = s1 == null ? "" : s1.trim();
        s2 = s2 == null ? "" : s2.trim();
        return s1.equals(s2);
    }

    @Override
    public QName getName() {
        String ln = null;
        String ns = null;
        short type = this.node.getNodeType();
        if (type == 1) {
            ns = DOMNodePointer.getPrefix(this.node);
            ln = DOMNodePointer.getLocalName(this.node);
        } else if (type == 7) {
            ln = ((ProcessingInstruction)this.node).getTarget();
        }
        return new QName(ns, ln);
    }

    @Override
    public String getNamespaceURI() {
        return DOMNodePointer.getNamespaceURI(this.node);
    }

    @Override
    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new DOMNodeIterator(this, test, reverse, startWith);
    }

    @Override
    public NodeIterator attributeIterator(QName name) {
        return new DOMAttributeIterator(this, name);
    }

    @Override
    public NodePointer namespacePointer(String prefix) {
        return new NamespacePointer((NodePointer)this, prefix);
    }

    @Override
    public NodeIterator namespaceIterator() {
        return new DOMNamespaceIterator(this);
    }

    @Override
    public synchronized NamespaceResolver getNamespaceResolver() {
        if (this.localNamespaceResolver == null) {
            this.localNamespaceResolver = new NamespaceResolver(super.getNamespaceResolver());
            this.localNamespaceResolver.setNamespaceContextPointer(this);
        }
        return this.localNamespaceResolver;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.getDefaultNamespaceURI();
        }
        if (prefix.equals("xml")) {
            return XML_NAMESPACE_URI;
        }
        if (prefix.equals("xmlns")) {
            return XMLNS_NAMESPACE_URI;
        }
        String namespace = null;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        } else {
            namespace = (String)this.namespaces.get(prefix);
        }
        if (namespace == null) {
            String qname = "xmlns:" + prefix;
            Node aNode = this.node;
            if (aNode instanceof Document) {
                aNode = ((Document)aNode).getDocumentElement();
            }
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode(qname)) != null) {
                    namespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
            if (namespace == null || namespace.equals("")) {
                namespace = "<<unknown namespace>>";
            }
        }
        this.namespaces.put(prefix, namespace);
        if (namespace == "<<unknown namespace>>") {
            return null;
        }
        return namespace;
    }

    @Override
    public String getDefaultNamespaceURI() {
        if (this.defaultNamespace == null) {
            Node aNode = this.node;
            if (aNode instanceof Document) {
                aNode = ((Document)aNode).getDocumentElement();
            }
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode("xmlns")) != null) {
                    this.defaultNamespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "";
        }
        return this.defaultNamespace.equals("") ? null : this.defaultNamespace;
    }

    @Override
    public Object getBaseValue() {
        return this.node;
    }

    @Override
    public Object getImmediateNode() {
        return this.node;
    }

    @Override
    public boolean isActual() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isLeaf() {
        return !this.node.hasChildNodes();
    }

    @Override
    public boolean isLanguage(String lang) {
        String current = this.getLanguage();
        return current == null ? super.isLanguage(lang) : current.toUpperCase(Locale.ENGLISH).startsWith(lang.toUpperCase(Locale.ENGLISH));
    }

    protected static String findEnclosingAttribute(Node n, String attrName) {
        while (n != null) {
            Element e;
            String attr;
            if (n.getNodeType() == 1 && (attr = (e = (Element)n).getAttribute(attrName)) != null && !attr.equals("")) {
                return attr;
            }
            n = n.getParentNode();
        }
        return null;
    }

    protected String getLanguage() {
        return DOMNodePointer.findEnclosingAttribute(this.node, "xml:lang");
    }

    @Override
    public void setValue(Object value) {
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            String string = (String)TypeUtils.convert(value, String.class);
            if (string != null && !string.equals("")) {
                this.node.setNodeValue(string);
            } else {
                this.node.getParentNode().removeChild(this.node);
            }
        } else {
            int count;
            NodeList children = this.node.getChildNodes();
            int i = count = children.getLength();
            while (--i >= 0) {
                Node child = children.item(i);
                this.node.removeChild(child);
            }
            if (value instanceof Node) {
                Node valueNode = (Node)value;
                if (valueNode instanceof Element || valueNode instanceof Document) {
                    children = valueNode.getChildNodes();
                    int i2 = 0;
                    while (i2 < children.getLength()) {
                        Node child = children.item(i2);
                        this.node.appendChild(child.cloneNode(true));
                        ++i2;
                    }
                } else {
                    this.node.appendChild(valueNode.cloneNode(true));
                }
            } else {
                String string = (String)TypeUtils.convert(value, String.class);
                if (string != null && !string.equals("")) {
                    Text textNode = this.node.getOwnerDocument().createTextNode(string);
                    this.node.appendChild(textNode);
                }
            }
        }
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index) {
        String prefix;
        String namespaceURI;
        NodeNameTest nodeTest;
        NodeIterator it;
        boolean success;
        if (index == Integer.MIN_VALUE) {
            index = 0;
        }
        if ((success = this.getAbstractFactory(context).createObject(context, this, this.node, name.toString(), index)) && (it = this.childIterator(nodeTest = new NodeNameTest(name, namespaceURI = (prefix = name.getPrefix()) == null ? null : context.getNamespaceURI(prefix)), false, null)) != null && it.setPosition(index + 1)) {
            return it.getNodePointer();
        }
        throw new JXPathAbstractFactoryException("Factory could not create a child node for path: " + this.asPath() + "/" + name + "[" + (index + 1) + "]");
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer ptr = this.createChild(context, name, index);
        ptr.setValue(value);
        return ptr;
    }

    @Override
    public NodePointer createAttribute(JXPathContext context, QName name) {
        if (!(this.node instanceof Element)) {
            return super.createAttribute(context, name);
        }
        Element element = (Element)this.node;
        String prefix = name.getPrefix();
        if (prefix != null) {
            String ns = null;
            NamespaceResolver nsr = this.getNamespaceResolver();
            if (nsr != null) {
                ns = nsr.getNamespaceURI(prefix);
            }
            if (ns == null) {
                throw new JXPathException("Unknown namespace prefix: " + prefix);
            }
            element.setAttributeNS(ns, name.toString(), "");
        } else if (!element.hasAttribute(name.getName())) {
            element.setAttribute(name.getName(), "");
        }
        NodeIterator it = this.attributeIterator(name);
        it.setPosition(1);
        return it.getNodePointer();
    }

    @Override
    public void remove() {
        Node parent = this.node.getParentNode();
        if (parent == null) {
            throw new JXPathException("Cannot remove root DOM node");
        }
        parent.removeChild(this.node);
    }

    @Override
    public String asPath() {
        if (this.id != null) {
            return "id('" + this.escape(this.id) + "')";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        switch (this.node.getNodeType()) {
            case 1: {
                if (!(this.parent instanceof DOMNodePointer)) break;
                if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append('/');
                }
                String ln = DOMNodePointer.getLocalName(this.node);
                String nsURI = this.getNamespaceURI();
                if (nsURI == null) {
                    buffer.append(ln);
                    buffer.append('[');
                    buffer.append(this.getRelativePositionByName()).append(']');
                    break;
                }
                String prefix = this.getNamespaceResolver().getPrefix(nsURI);
                if (prefix != null) {
                    buffer.append(prefix);
                    buffer.append(':');
                    buffer.append(ln);
                    buffer.append('[');
                    buffer.append(this.getRelativePositionByName());
                    buffer.append(']');
                    break;
                }
                buffer.append("node()");
                buffer.append('[');
                buffer.append(this.getRelativePositionOfElement());
                buffer.append(']');
                break;
            }
            case 3: 
            case 4: {
                buffer.append("/text()");
                buffer.append('[');
                buffer.append(this.getRelativePositionOfTextNode()).append(']');
                break;
            }
            case 7: {
                buffer.append("/processing-instruction('");
                buffer.append(((ProcessingInstruction)this.node).getTarget()).append("')");
                buffer.append('[');
                buffer.append(this.getRelativePositionOfPI()).append(']');
                break;
            }
            case 9: {
                break;
            }
        }
        return buffer.toString();
    }

    private int getRelativePositionByName() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            String nm;
            if (n.getNodeType() == 1 && (nm = n.getNodeName()).equals(this.node.getNodeName())) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfElement() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfTextNode() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfPI() {
        int count = 1;
        String target = ((ProcessingInstruction)this.node).getTarget();
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 7 && ((ProcessingInstruction)n).getTarget().equals(target)) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DOMNodePointer && this.node == ((DOMNodePointer)object).node;
    }

    public static String getPrefix(Node node) {
        String prefix = node.getPrefix();
        if (prefix != null) {
            return prefix;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        return index < 0 ? null : name.substring(0, index);
    }

    public static String getLocalName(Node node) {
        String localName = node.getLocalName();
        if (localName != null) {
            return localName;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        return index < 0 ? name : name.substring(index + 1);
    }

    public static String getNamespaceURI(Node node) {
        Element element;
        String uri;
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        if ((uri = (element = (Element)node).getNamespaceURI()) != null) {
            return uri;
        }
        String prefix = DOMNodePointer.getPrefix(node);
        String qname = prefix == null ? "xmlns" : "xmlns:" + prefix;
        Node aNode = node;
        while (aNode != null) {
            Attr attr;
            if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode(qname)) != null) {
                return attr.getValue();
            }
            aNode = aNode.getParentNode();
        }
        return null;
    }

    @Override
    public Object getValue() {
        if (this.node.getNodeType() == 8) {
            String text = ((Comment)this.node).getData();
            return text == null ? "" : text.trim();
        }
        return this.stringValue(this.node);
    }

    private String stringValue(Node node) {
        boolean trim;
        short nodeType = node.getNodeType();
        if (nodeType == 8) {
            return "";
        }
        boolean bl = trim = !"preserve".equals(DOMNodePointer.findEnclosingAttribute(node, "xml:space"));
        if (nodeType == 3 || nodeType == 4) {
            String text = node.getNodeValue();
            return text == null ? "" : (trim ? text.trim() : text);
        }
        if (nodeType == 7) {
            String text = ((ProcessingInstruction)node).getData();
            return text == null ? "" : (trim ? text.trim() : text);
        }
        NodeList list = node.getChildNodes();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            buf.append(this.stringValue(child));
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Pointer getPointerByID(JXPathContext context, String id) {
        Document document = this.node.getNodeType() == 9 ? (Document)this.node : this.node.getOwnerDocument();
        Element element = document.getElementById(id);
        return element == null ? new NullPointer(this.getLocale(), id) : new DOMNodePointer(element, this.getLocale(), id);
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        Node node2;
        Node node1 = (Node)pointer1.getBaseValue();
        if (node1 == (node2 = (Node)pointer2.getBaseValue())) {
            return 0;
        }
        short t1 = node1.getNodeType();
        short t2 = node2.getNodeType();
        if (t1 == 2 && t2 != 2) {
            return -1;
        }
        if (t1 != 2 && t2 == 2) {
            return 1;
        }
        if (t1 == 2 && t2 == 2) {
            NamedNodeMap map = ((Node)this.getNode()).getAttributes();
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                Node n = map.item(i);
                if (n == node1) {
                    return -1;
                }
                if (n == node2) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        Node current = this.node.getFirstChild();
        while (current != null) {
            if (current == node1) {
                return -1;
            }
            if (current == node2) {
                return 1;
            }
            current = current.getNextSibling();
        }
        return 0;
    }
}

