/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import ext.base.core.BcStringUtil;
import ext.lib.awt.AwtImageObserver;
import ext.lib.doc.util.DcfDocumentUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.EnumMap;
import nlc.lib.barcode.DcfAbstractBarcodeContext;
import nlc.lib.barcode.DcfBarcodeRenderer;

public class DcfBarcodeContext
extends DcfAbstractBarcodeContext
implements Serializable,
DcfBarcodeRenderer {
    private static final long serialVersionUID = 3747647973647550270L;
    private String barcodeType;
    private BarcodeFormat barcodeFormat;
    public double widthMm = 35.0;
    public double heightMm = 8.0;
    private BufferedImage bufferedImage;

    public String getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
        if ("code128".equals(barcodeType)) {
            this.barcodeFormat = BarcodeFormat.CODE_128;
        } else if ("code39".equals(barcodeType)) {
            this.barcodeFormat = BarcodeFormat.CODE_39;
        }
    }

    @Override
    public double[] getSize(String value) throws Exception {
        this.createImage(value);
        double[] dim = new double[]{this.bufferedImage.getWidth(), this.bufferedImage.getHeight()};
        return dim;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String value) throws Exception {
        this.createImage(value);
        AwtImageObserver imageObserver = new AwtImageObserver();
        g2d.drawImage(this.bufferedImage, (int)bx, (int)by, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), imageObserver);
    }

    protected synchronized void createImage(String barcodeValue) throws Exception {
        if (BcStringUtil.equals(barcodeValue, barcodeValue) && this.bufferedImage != null) {
            return;
        }
        int width = (int)DcfDocumentUtil.mmToPixel(this.widthMm);
        int height = (int)DcfDocumentUtil.mmToPixel(this.heightMm);
        EnumMap<EncodeHintType, String> hintMap = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        Writer writer = DcfBarcodeContext.createWriter(this.barcodeFormat);
        BitMatrix bitMatrix = writer.encode(barcodeValue, this.barcodeFormat, width, height, hintMap);
        this.bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
    }

    public static Writer createWriter(BarcodeFormat barcodeFormat) {
        Code39Writer writer = new Code39Writer();
        if (BarcodeFormat.CODE_39.equals((Object)barcodeFormat)) {
            writer = new Code39Writer();
        } else if (BarcodeFormat.CODE_128.equals((Object)barcodeFormat)) {
            writer = new Code128Writer();
        }
        return writer;
    }
}

