/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.fx;

import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.table.BcTableModel;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.table.FxTableViewEvent;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgUtil;
import ext.scf.client.ScfClientContainer;
import ext.scf3.client.ScfTableLoadTask;
import ext.scf4.fx.HfxAbstractSearchPane;
import ext.scf4.fx.HfxLoadableTablePane;
import ext.scf4.fx.TmpControler;
import ext.scf4.fx.TmpEvent;
import ext.scf6.fx.JfxTableControlPane2;
import java.awt.Image;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public abstract class JfxAabstractDataViewPane
extends HfxAbstractSearchPane
implements FxTableViewEvent {
    private Map<Integer, Node> contentMap = new HashMap<Integer, Node>();
    protected JfxTableControlPane2 tableControlPane;

    protected abstract Node createConditionNode(Node var1) throws Exception;

    @Override
    protected void addTad(Node contentNode) throws Exception {
        Node conditionNode = this.getConditionNode();
        this.contentMap.put(contentNode.hashCode(), conditionNode);
        super.addTad(contentNode);
    }

    @Override
    protected void tabSelected(Node contentNode) throws Exception {
        super.tabSelected(contentNode);
        Node conditionNode = this.contentMap.get(contentNode.hashCode());
        Node newConditionNode = this.createConditionNode(conditionNode);
        this.setConditionNode(newConditionNode);
    }

    @Override
    public void doSerch() throws Exception {
        FxBorderPane borderPane = new FxBorderPane();
        TmpControler tmpControler = new TmpControler();
        this.tableControlPane = this.createTableControlPane();
        this.tableControlPane.setTmpControler(tmpControler);
        borderPane.setBottom((Node)this.tableControlPane);
        RmiRequest rmiReq = this.createRequest();
        HfxLoadableTablePane loadableTablePane = this.createTablePane(tmpControler);
        loadableTablePane.doLoad(rmiReq);
        borderPane.setCenter((Node)loadableTablePane);
        tmpControler.addEventHandler(ev -> this.handleEvent(ev, loadableTablePane));
        this.addTad((Node)borderPane);
    }

    protected Object handleEvent(Object ev, HfxLoadableTablePane loadableTablePane) {
        if (ev instanceof TmpEvent) {
            TmpEvent tmpEvent = (TmpEvent)ev;
            try {
                return this.handleEvent_L2(tmpEvent, loadableTablePane);
            }
            catch (Exception ex) {
                SwgUtil.getExceptionHandler().handleException(ex, this);
            }
        }
        return null;
    }

    protected Object handleEvent_L2(TmpEvent ev, HfxLoadableTablePane loadableTablePane) throws Exception {
        if (ev.getEventType() == TmpEvent.EventType.reload) {
            loadableTablePane.doLoad(loadableTablePane.getRequest());
        } else {
            ev.getEventType();
        }
        return null;
    }

    protected HfxLoadableTablePane createTablePane(TmpControler tmpControler) throws Exception {
        InnerTablePane tablePanel = new InnerTablePane(tmpControler);
        return tablePanel;
    }

    protected JfxTableControlPane2 createTableControlPane() throws Exception {
        InnerTableControlPane tableOptionPane = new InnerTableControlPane();
        return tableOptionPane;
    }

    @Override
    protected void setStageOption(Stage stage) throws Exception {
        super.setStageOption(stage);
        Image awtImage = AwtImageHelper.getImage("document_64x64.png");
        javafx.scene.image.Image stageIcon = FxUtil.convImage(awtImage);
        stage.getIcons().add((Object)stageIcon);
    }

    protected abstract RmiRequest createRequest() throws Exception;

    protected void tableLoadFinished(TableView tableView, BcTableColumnModel tableColumnModel, BcTableContext tableContext) throws Exception {
    }

    protected RmiAgent getAgent() throws Exception {
        return ScfClientContainer.getInstance().getAgent();
    }

    protected class InnerTableControlPane
    extends JfxTableControlPane2 {
    }

    public class InnerTablePane
    extends HfxLoadableTablePane {
        TmpControler tmpControler;

        public InnerTablePane(TmpControler tmpControler) throws Exception {
            this.tmpControler = tmpControler;
        }

        @Override
        public void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
            super.rowListReceived(tableLoadTask, rowList);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        InnerTablePane.this.tmpControler.rowCountProperty.setValue((Number)InnerTablePane.this.getTableView().getItems().size());
                    }
                    catch (Exception ex) {
                        InnerTablePane.this.handleException(ex);
                    }
                }
            });
        }

        @Override
        public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
            super.tableLoadFinished(tableLoadTask, eod);
            BcTableModel tableModel = new BcTableModel(this.tableColumnModel);
            tableModel.addRowList((List<List>)this.getTableView().getItems());
            JfxAabstractDataViewPane.this.tableControlPane.setData(this.tableColumnModel, tableModel, this.tableContext);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        InnerTablePane.this.tmpControler.rowCountProperty.setValue((Number)InnerTablePane.this.getTableView().getItems().size());
                    }
                    catch (Exception ex) {
                        InnerTablePane.this.handleException(ex);
                    }
                }
            });
            JfxAabstractDataViewPane.this.tableLoadFinished(this.getTableView(), this.tableColumnModel, this.tableContext);
        }

        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged(tableView, rowIdList, prevRowId, nextRowId);
            JfxAabstractDataViewPane.this.rowSelectionChanged(tableView, rowIdList, prevRowId, nextRowId);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            JfxAabstractDataViewPane.this.rowSelected(tableView, tablePositionList, ev, doubleClicked);
        }
    }
}

