/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.dao;

import ext.base.core.BcInteger;
import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.context.SqlContext;
import ext.scf4.model.ScfIntPropertyElement;
import ext.scf5.model.ZScfIntProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScfAbstractIntPropertyDAO
extends OrmAbstractDAO<ScfIntPropertyElement> {
    protected String column_item_id = "item_id";
    protected String column_index = "index_";
    protected String column_value = "value_";

    public ScfAbstractIntPropertyDAO() {
        super(new ScfIntPropertyElement[0]);
    }

    public void putPropertyElement(DtsSession dtsSession, ScfIntPropertyElement propertyElement) throws Exception {
        this.getPersistenceProxy().putEntitys_3(dtsSession, this.getTableName(), propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, int itemId, int index, CharSequence value) throws Exception {
        ScfIntPropertyElement propertyElement = new ScfIntPropertyElement();
        propertyElement.itemId = itemId;
        propertyElement.index = index;
        if (!BcStringUtil.isEmpty(value)) {
            propertyElement.value = value.toString();
        }
        this.putPropertyElement(dtsSession, propertyElement);
    }

    public void putPropertyElement(DtsSession dtsSession, int itemId, CharSequence value) throws Exception {
        this.putPropertyElement(dtsSession, itemId, 1, value);
    }

    public void putPropertyElement(DtsSession dtsSession, ZScfIntProperties intProps) throws Exception {
        Object[] keys = intProps.keySet().toArray();
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Integer itemId = (Integer)keys[i];
            String value = intProps.get(itemId);
            this.putPropertyElement(dtsSession, itemId, value);
            ++i;
        }
    }

    protected void getPropertyElement(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, ScfIntPropertyElement propertyElement) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, propertyElement);
        propertyElement.itemId = rs.getInt(columnIndex);
        propertyElement.index = rs.getInt(columnIndex);
        propertyElement.value = rs.getString(columnIndex);
    }

    protected ScfIntPropertyElement getPropertyElement(DtsSession dtsSession, String query) throws Exception {
        ScfIntPropertyElement propertyElement = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                propertyElement = new ScfIntPropertyElement();
                this.getPropertyElement(dtsSession, rs, columnIndex, propertyElement);
            }
            rs.close();
        }
        return propertyElement;
    }

    protected List<ScfIntPropertyElement> getPropertyElementList(DtsSession dtsSession, String query) throws Exception {
        ArrayList<ScfIntPropertyElement> propertyElementList = new ArrayList<ScfIntPropertyElement>();
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            BcInteger columnIndex = new BcInteger();
            while (rs.next()) {
                columnIndex.value = 0;
                ScfIntPropertyElement propertyElement = new ScfIntPropertyElement();
                this.getPropertyElement(dtsSession, rs, columnIndex, propertyElement);
                propertyElementList.add(propertyElement);
            }
            rs.close();
        }
        return propertyElementList;
    }

    public ScfIntPropertyElement getPropertyElement(DtsSession dtsSession, int itemId, int index) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + " WHERE " + this.column_item_id + "=" + itemId + " AND " + this.column_index + "=" + index;
        return this.getPropertyElement(dtsSession, query);
    }

    public ScfIntPropertyElement getPropertyElement(DtsSession dtsSession, int itemId) throws Exception {
        return this.getPropertyElement(dtsSession, itemId, 1);
    }

    public String getValue(DtsSession dtsSession, int itemId, int index) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "SELECT " + this.column_value + " FROM " + this.getTableName() + " WHERE " + this.column_item_id + "=" + itemId + " AND " + this.column_index + "=" + index;
        String value = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                value = rs.getString(1);
            }
            rs.close();
        }
        return value;
    }

    public String getValue(DtsSession dtsSession, int itemId) throws Exception {
        return this.getValue(dtsSession, itemId, 1);
    }

    public List<ScfIntPropertyElement> getPropertyElementList(DtsSession dtsSession) throws Exception {
        String query = "SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.getTableName() + " ORDER BY " + this.column_item_id + ", " + this.column_index;
        return this.getPropertyElementList(dtsSession, query);
    }

    public ZScfIntProperties getPropertyAsIntProps(DtsSession dtsSession) throws Exception {
        ZScfIntProperties intProps = new ZScfIntProperties();
        List<ScfIntPropertyElement> propertyElementList = this.getPropertyElementList(dtsSession);
        int i = 0;
        while (i < propertyElementList.size()) {
            ScfIntPropertyElement propertyElement = propertyElementList.get(i);
            intProps.put((Integer)propertyElement.itemId, propertyElement.value);
            ++i;
        }
        return intProps;
    }
}

