/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.validation;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdField;
import ext.base.reflect.BcReflectUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcResult;
import ext.module.xmmd.common.XmmdUtil;
import ext.module.xsys.common.XsysWords;
import ext.module.xsys.validation.XsysFieldKeyCreator;
import ext.module.xsys.validation.XsysValidationElement;
import ext.module.xsys.validation.XwebValidationResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XwebValidator
extends BcLoggableObject {
    public static XwebValidator getInstance() {
        return SingletonHolder.instance;
    }

    public XwebValidationResult validate(Object entity) throws Exception {
        String entityName = entity.getClass().getSimpleName();
        return this.validate(entity, entityName);
    }

    protected XwebValidationResult validate(Object entity, String entityName) throws Exception {
        XwebValidationResult validationResult = new XwebValidationResult();
        Class<?> entityClass = entity.getClass();
        List<Map.Entry<Field, MmdField>> mapEntryList1 = XmmdUtil.createFieldEntryList(entityClass);
        int i = 0;
        while (i < mapEntryList1.size()) {
            Object fieldValue;
            MmdField mmdField;
            Map.Entry<Field, MmdField> mapEntry = mapEntryList1.get(i);
            Field field = mapEntry.getKey();
            List msgList = this.validate(entity, field, mmdField = mapEntry.getValue(), fieldValue = BcReflectUtil.getFieldValue(field, entity));
            if (!BcCollectionUtil.isEmpty(msgList)) {
                String key = XsysFieldKeyCreator.getInstance().createKey(entityName, mmdField.fieldName);
                XsysValidationElement validationElement = new XsysValidationElement();
                validationElement.field = field;
                validationElement.mmdField = mmdField;
                validationElement.value = fieldValue;
                validationElement.msgList = msgList;
                validationResult.fieldErrMap.put(key, validationElement);
            }
            ++i;
        }
        return validationResult;
    }

    protected List validate(Object entity, Field field, MmdField mmdField, Object fieldValue) throws Exception {
        Pattern pattern;
        Matcher matcher;
        ArrayList<String> msgList = new ArrayList<String>();
        if (mmdField.required) {
            if (BcStringUtil.isEmpty(fieldValue)) {
                msgList.add(XsysWords.getInstance().\u5fc5\u9808\u9805\u76ee\u3067\u3059);
            }
            return msgList;
        }
        String strValue = BcStringUtil.toStringNotNull(fieldValue);
        if (mmdField.dataSize > 0 && strValue.length() > mmdField.dataSize) {
            msgList.add(String.format("\u6700\u5927 %d \u6587\u5b57\u3067\u3059\u3002", mmdField.dataSize));
        }
        if (!BcStringUtil.isEmpty(mmdField.inputPattern) && !(matcher = (pattern = Pattern.compile(mmdField.inputPattern)).matcher(strValue)).matches()) {
            msgList.add(this.createPatternUnmatchMessage(entity, field, mmdField, fieldValue));
        }
        return msgList;
    }

    protected String createPatternUnmatchMessage(Object entity, Field field, MmdField mmdField, Object fieldValue) throws Exception {
        return "\u30d1\u30bf\u30fc\u30f3\u306b\u5408\u81f4\u3057\u307e\u305b\u3093\u3002" + mmdField.inputPattern;
    }

    public BcResult validateForGui(Object entity) throws Exception {
        XwebValidationResult validationResult = this.validate(entity);
        return this.inputErrorPreprocessing(validationResult);
    }

    public BcResult inputErrorPreprocessing(XwebValidationResult validationResult) throws Exception {
        BcResult result = new BcResult();
        for (Map.Entry<String, XsysValidationElement> mapEntry : validationResult.fieldErrMap.entrySet()) {
            this.getLogger().debug("key=" + mapEntry.getKey());
            XsysValidationElement validationElement = mapEntry.getValue();
            ArrayList<String> msgList2 = new ArrayList<String>();
            for (Object msg : validationElement.msgList) {
                String newMsgString = String.valueOf(validationElement.mmdField.displayName) + "\u306f" + msg;
                msgList2.add(newMsgString);
            }
            result.getErrorList().addAll(msgList2);
        }
        return result;
    }

    private static final class SingletonHolder {
        private static final XwebValidator instance = new XwebValidator();

        private SingletonHolder() {
        }
    }
}

