/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.libx.etc.model.EtcWord;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XdtsWordXmlCreator {
    File destFile;

    public void createXml(Collection<EtcWord> wordCollection, File destFile) throws Exception {
        this.destFile = destFile;
        Document xmlDoc = this.createXml_L2(wordCollection);
        BcXmlUtil.output(xmlDoc, destFile, true, "UTF-8");
    }

    protected Document createXml_L2(Collection<EtcWord> wordCollection) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document xmlDoc = documentBuilder.newDocument();
        Element rootElem = xmlDoc.createElement("words");
        xmlDoc.appendChild(rootElem);
        Iterator<EtcWord> iterator = wordCollection.iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            if (++cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            EtcWord word = iterator.next();
            this.createXml_L3(rootElem, word);
        }
        return xmlDoc;
    }

    protected void createXml_L3(Element rootElem, EtcWord word) throws Exception {
        Element wordElem = BcXmlUtil.createElement(rootElem, "word");
        wordElem.setAttribute("code", word.code);
        if (!BcStringUtil.isEmpty(word.value)) {
            Element valueElem = BcXmlUtil.createElement(wordElem, "value");
            valueElem.setAttribute("lang", word.lang);
            BcXmlUtil.setTextValue(valueElem, word.value);
        }
        if (!BcStringUtil.isEmpty(word.note)) {
            Element noteElem = BcXmlUtil.createElement(wordElem, "note");
            BcXmlUtil.setTextValue(noteElem, word.note);
        }
    }
}

