/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.util.BcCollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BcResult
implements Serializable {
    private static final long serialVersionUID = 2455615539627034659L;
    private Object userObject;
    private List<Object> inforList;
    private List<Object> warnList;
    private List<Object> errorList;

    public BcResult() {
        this.clear();
    }

    public void clear() {
        this.userObject = null;
        this.inforList = null;
        this.warnList = null;
        this.errorList = null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public int addInfo(Object object) {
        this.getInfoList().add(object);
        return this.getInfoList().size();
    }

    public int addWarn(Object object) {
        this.getWarnList().add(object);
        return this.getWarnList().size();
    }

    public int addError(Object object) {
        this.getErrorList().add(object);
        return this.getErrorList().size();
    }

    public List<Object> getInfoList() {
        if (this.inforList == null) {
            this.inforList = new ArrayList<Object>();
        }
        return this.inforList;
    }

    public List<Object> getWarnList() {
        if (this.warnList == null) {
            this.warnList = new ArrayList<Object>();
        }
        return this.warnList;
    }

    public List<Object> getErrorList() {
        if (this.errorList == null) {
            this.errorList = new ArrayList<Object>();
        }
        return this.errorList;
    }

    public boolean hasInfo() {
        return BcCollectionUtil.getSize(this.inforList) > 0;
    }

    public boolean hasWarn() {
        return BcCollectionUtil.getSize(this.warnList) > 0;
    }

    public boolean hasError() {
        return BcCollectionUtil.getSize(this.errorList) > 0;
    }

    public void addResult(BcResult result) {
        if (result.hasInfo()) {
            this.getInfoList().addAll(result.getInfoList());
        }
        if (result.hasWarn()) {
            this.getWarnList().addAll(result.getWarnList());
        }
        if (result.hasError()) {
            this.getErrorList().addAll(result.getErrorList());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n userObject=" + this.userObject);
        sb.append("\n inforList=" + this.inforList);
        sb.append("\n warnList=" + this.warnList);
        sb.append("\n errorList=" + this.errorList);
        return sb.toString();
    }
}

