/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;

class OracleBlobOutputStream
extends OutputStream {
    long lobOffset;
    OracleBlob blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;

    public OracleBlobOutputStream(BLOB blob, int bufferSize) throws SQLException {
        this((OracleBlob)blob, bufferSize);
    }

    public OracleBlobOutputStream(OracleBlob blob, int bufferSize) throws SQLException {
        this(blob, bufferSize, 1L);
    }

    public OracleBlobOutputStream(BLOB blob, int bufferSize, long offset) throws SQLException {
        this((OracleBlob)blob, bufferSize, offset);
    }

    public OracleBlobOutputStream(OracleBlob blob, int bufferSize, long offset) throws SQLException {
        if (blob == null || bufferSize <= 0 || offset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = blob;
        this.lobOffset = offset;
        PhysicalConnection pConnection = (PhysicalConnection)blob.getInternalConnection();
        try (Monitor.CloseableLock lock = pConnection.acquireCloseableLock();){
            this.buf = pConnection.getByteBuffer(bufferSize);
        }
        this.count = 0;
        this.bufSize = bufferSize;
        this.isClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (this.count >= this.bufSize) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        int start = off;
        int lengthToWrite = Math.min(len, b.length - off);
        if (lengthToWrite >= 2 * this.bufSize) {
            if (this.count > 0) {
                this.flushBuffer();
            }
            try {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, b, off, lengthToWrite);
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        } else {
            int end = start + lengthToWrite;
            while (start < end) {
                int bytesWritten = Math.min(this.bufSize - this.count, end - start);
                System.arraycopy(b, start, this.buf, this.count, bytesWritten);
                start += bytesWritten;
                this.count += bytesWritten;
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.flushBuffer();
            return;
        }
        finally {
            try {
                PhysicalConnection pConnection = (PhysicalConnection)this.blob.getInternalConnection();
                try (Monitor.CloseableLock lock = pConnection.acquireCloseableLock();){
                    if (this.buf != null) {
                        pConnection.cacheBuffer(this.buf);
                        this.buf = null;
                    }
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                this.lobOffset += (long)this.blob.setBytes(this.lobOffset, this.buf, 0, this.count);
                this.count = 0;
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.blob.getInternalConnection();
        }
        catch (Exception exc) {
            return null;
        }
    }
}

