/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sun.util.locale.LocaleEquivalentMaps;

public final class LocaleMatcher {
    public static List<Locale> filter(List<Locale.LanguageRange> list, Collection<Locale> collection, Locale.FilteringMode filteringMode) {
        if (list.isEmpty() || collection.isEmpty()) {
            return new ArrayList<Locale>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale cloneable2 : collection) {
            arrayList.add(cloneable2.toLanguageTag());
        }
        List<String> list2 = LocaleMatcher.filterTags(list, arrayList, filteringMode);
        ArrayList<Locale> arrayList2 = new ArrayList<Locale>(list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList2.add(Locale.forLanguageTag(string));
        }
        return arrayList2;
    }

    public static List<String> filterTags(List<Locale.LanguageRange> list, Collection<String> collection, Locale.FilteringMode filteringMode) {
        if (list.isEmpty() || collection.isEmpty()) {
            return new ArrayList<String>();
        }
        if (filteringMode == Locale.FilteringMode.EXTENDED_FILTERING) {
            return LocaleMatcher.filterExtended(list, collection);
        }
        ArrayList<Locale.LanguageRange> arrayList = new ArrayList<Locale.LanguageRange>();
        for (Locale.LanguageRange languageRange : list) {
            String string = languageRange.getRange();
            if (string.startsWith("*-") || string.indexOf("-*") != -1) {
                if (filteringMode == Locale.FilteringMode.AUTOSELECT_FILTERING) {
                    return LocaleMatcher.filterExtended(list, collection);
                }
                if (filteringMode == Locale.FilteringMode.MAP_EXTENDED_RANGES) {
                    string = string.charAt(0) == '*' ? "*" : string.replaceAll("-[*]", "");
                    arrayList.add(new Locale.LanguageRange(string, languageRange.getWeight()));
                    continue;
                }
                if (filteringMode != Locale.FilteringMode.REJECT_EXTENDED_RANGES) continue;
                throw new IllegalArgumentException("An extended range \"" + string + "\" found in REJECT_EXTENDED_RANGES mode.");
            }
            arrayList.add(languageRange);
        }
        return LocaleMatcher.filterBasic(arrayList, collection);
    }

    private static List<String> filterBasic(List<Locale.LanguageRange> list, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale.LanguageRange languageRange : list) {
            String string = languageRange.getRange();
            if (string.equals("*")) {
                return new ArrayList<String>(collection);
            }
            for (String string2 : collection) {
                if (!(string2 = string2.toLowerCase()).startsWith(string)) continue;
                int n = string.length();
                if (string2.length() != n && string2.charAt(n) != '-' || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static List<String> filterExtended(List<Locale.LanguageRange> list, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale.LanguageRange languageRange : list) {
            String string = languageRange.getRange();
            if (string.equals("*")) {
                return new ArrayList<String>(collection);
            }
            String[] stringArray = string.split("-");
            for (String string2 : collection) {
                String[] stringArray2 = (string2 = string2.toLowerCase()).split("-");
                if (!stringArray[0].equals(stringArray2[0]) && !stringArray[0].equals("*")) continue;
                int n = 1;
                int n2 = 1;
                while (n < stringArray.length && n2 < stringArray2.length) {
                    if (stringArray[n].equals("*")) {
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals(stringArray2[n2])) {
                        ++n;
                        ++n2;
                        continue;
                    }
                    if (stringArray2[n2].length() == 1 && !stringArray2[n2].equals("*")) break;
                    ++n2;
                }
                if (stringArray.length != n || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static Locale lookup(List<Locale.LanguageRange> list, Collection<Locale> collection) {
        if (list.isEmpty() || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale locale : collection) {
            arrayList.add(locale.toLanguageTag());
        }
        String string = LocaleMatcher.lookupTag(list, arrayList);
        if (string == null) {
            return null;
        }
        return Locale.forLanguageTag(string);
    }

    public static String lookupTag(List<Locale.LanguageRange> list, Collection<String> collection) {
        if (list.isEmpty() || collection.isEmpty()) {
            return null;
        }
        for (Locale.LanguageRange languageRange : list) {
            String string = languageRange.getRange();
            if (string.equals("*")) continue;
            String string2 = string.replaceAll("\\x2A", "\\\\p{Alnum}*");
            while (!string2.isEmpty()) {
                for (String string3 : collection) {
                    if (!(string3 = string3.toLowerCase()).matches(string2)) continue;
                    return string3;
                }
                int n = string2.lastIndexOf(45);
                if (n >= 0) {
                    if ((string2 = string2.substring(0, n)).lastIndexOf(45) != string2.length() - 2) continue;
                    string2 = string2.substring(0, string2.length() - 2);
                    continue;
                }
                string2 = "";
            }
        }
        return null;
    }

    public static List<Locale.LanguageRange> parse(String string) {
        if ((string = string.replaceAll(" ", "").toLowerCase()).startsWith("accept-language:")) {
            string = string.substring(16);
        }
        String[] stringArray = string.split(",");
        ArrayList<Locale.LanguageRange> arrayList = new ArrayList<Locale.LanguageRange>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        for (String string2 : stringArray) {
            String[] stringArray2;
            double d;
            String string3;
            int n2 = string2.indexOf(";q=");
            if (n2 == -1) {
                string3 = string2;
                d = 1.0;
            } else {
                string3 = string2.substring(0, n2);
                n2 += 3;
                try {
                    d = Double.parseDouble(string2.substring(n2));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("weight=\"" + string2.substring(n2) + "\" for language range \"" + string3 + "\"");
                }
                if (d < 0.0 || d > 1.0) {
                    throw new IllegalArgumentException("weight=" + d + " for language range \"" + string3 + "\". It must be between " + 0.0 + " and " + 1.0 + ".");
                }
            }
            if (arrayList2.contains(string3)) continue;
            Locale.LanguageRange languageRange = new Locale.LanguageRange(string3, d);
            n2 = n;
            for (int i = 0; i < n; ++i) {
                if (!(((Locale.LanguageRange)arrayList.get(i)).getWeight() < d)) continue;
                n2 = i;
                break;
            }
            arrayList.add(n2, languageRange);
            ++n;
            arrayList2.add(string3);
            String string4 = LocaleMatcher.getEquivalentForRegionAndVariant(string3);
            if (string4 != null && !arrayList2.contains(string4)) {
                arrayList.add(n2 + 1, new Locale.LanguageRange(string4, d));
                ++n;
                arrayList2.add(string4);
            }
            if ((stringArray2 = LocaleMatcher.getEquivalentsForLanguage(string3)) == null) continue;
            for (String string5 : stringArray2) {
                if (!arrayList2.contains(string5)) {
                    arrayList.add(n2 + 1, new Locale.LanguageRange(string5, d));
                    ++n;
                    arrayList2.add(string5);
                }
                if ((string4 = LocaleMatcher.getEquivalentForRegionAndVariant(string5)) == null || arrayList2.contains(string4)) continue;
                arrayList.add(n2 + 1, new Locale.LanguageRange(string4, d));
                ++n;
                arrayList2.add(string4);
            }
        }
        return arrayList;
    }

    private static String[] getEquivalentsForLanguage(String string) {
        String string2 = string;
        while (!string2.isEmpty()) {
            if (LocaleEquivalentMaps.singleEquivMap.containsKey(string2)) {
                String string3 = LocaleEquivalentMaps.singleEquivMap.get(string2);
                return new String[]{string.replaceFirst(string2, string3)};
            }
            if (LocaleEquivalentMaps.multiEquivsMap.containsKey(string2)) {
                String[] stringArray = LocaleEquivalentMaps.multiEquivsMap.get(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = string.replaceFirst(string2, stringArray[i]);
                }
                return stringArray;
            }
            int n = string2.lastIndexOf(45);
            if (n == -1) break;
            string2 = string2.substring(0, n);
        }
        return null;
    }

    private static String getEquivalentForRegionAndVariant(String string) {
        int n = LocaleMatcher.getExtentionKeyIndex(string);
        for (String string2 : LocaleEquivalentMaps.regionVariantEquivMap.keySet()) {
            int n2 = string.indexOf(string2);
            if (n2 == -1 || n != Integer.MIN_VALUE && n2 > n) continue;
            int n3 = n2 + string2.length();
            if (string.length() != n3 && string.charAt(n3) != '-') continue;
            return string.replaceFirst(string2, LocaleEquivalentMaps.regionVariantEquivMap.get(string2));
        }
        return null;
    }

    private static int getExtentionKeyIndex(String string) {
        char[] cArray = string.toCharArray();
        int n = Integer.MIN_VALUE;
        for (int i = 1; i < cArray.length; ++i) {
            if (cArray[i] != '-') continue;
            if (i - n == 2) {
                return n;
            }
            n = i;
        }
        return Integer.MIN_VALUE;
    }

    public static List<Locale.LanguageRange> mapEquivalents(List<Locale.LanguageRange> list, Map<String, List<String>> map) {
        if (list.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>();
        }
        if (map == null || map.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>(list);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object : map.keySet()) {
            hashMap.put(object.toLowerCase(), object);
        }
        ArrayList arrayList = new ArrayList();
        for (Locale.LanguageRange languageRange : list) {
            String string;
            String string2 = string = languageRange.getRange();
            boolean bl = false;
            while (!string2.isEmpty()) {
                if (hashMap.containsKey(string2)) {
                    bl = true;
                    List<String> n = map.get(hashMap.get(string2));
                    if (n == null) break;
                    int n2 = string2.length();
                    for (String string3 : n) {
                        arrayList.add(new Locale.LanguageRange(string3.toLowerCase() + string.substring(n2), languageRange.getWeight()));
                    }
                    break;
                }
                int n = string2.lastIndexOf(45);
                if (n == -1) break;
                string2 = string2.substring(0, n);
            }
            if (bl) continue;
            arrayList.add(languageRange);
        }
        return arrayList;
    }

    private LocaleMatcher() {
    }
}

