/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.NameFinderIF;
import ext.lib.nlp.NlpElement;
import ext.lib.nlp.NlpNoun;
import java.util.ArrayList;
import java.util.List;

public abstract class ExtNameFinderImpl0
extends BcLoggableObject
implements NameFinderIF {
    protected int max = 6;

    public ExtNameFinderImpl0() throws Exception {
        this.setup();
    }

    public void setup() throws Exception {
    }

    @Override
    public List<NlpElement> findName(List<KrmjTokenWrap> tokenWrapList) throws Exception {
        List<NlpElement> elementList = this.findName_L2(tokenWrapList);
        return elementList;
    }

    protected List<NlpElement> findName_L2(List<KrmjTokenWrap> tokenWrapList1) throws Exception {
        ArrayList<NlpElement> elementList = new ArrayList<NlpElement>();
        int i = 0;
        while (i < tokenWrapList1.size()) {
            KrmjTokenWrap tokenWrap1 = tokenWrapList1.get(i);
            if (!this.isSkip(tokenWrap1)) {
                int loopMax = Math.min(this.max, tokenWrapList1.size() - i - 1);
                int j = 0;
                while (j < loopMax) {
                    List<KrmjTokenWrap> tokenWrapList2;
                    NlpNoun noun;
                    int toIndex = i + loopMax - j + 1;
                    if (toIndex <= tokenWrapList1.size() && (noun = this.findName_L3(tokenWrapList2 = tokenWrapList1.subList(i, toIndex))) != null) {
                        NlpElement nlpElement = new NlpElement();
                        nlpElement.noun = noun;
                        nlpElement.tokenWrapList = tokenWrapList2;
                        elementList.add(nlpElement);
                        tokenWrap1.top = true;
                        KrmjTokenWrap tokenWrapLast = BcCollectionUtil.getLast(tokenWrapList2);
                        tokenWrapLast.last = true;
                        i += tokenWrapList2.size() - 1;
                        int k = 0;
                        while (k < tokenWrapList2.size()) {
                            KrmjTokenWrap tokenWrap2 = tokenWrapList2.get(k);
                            ++tokenWrap2.cnt;
                            ++k;
                        }
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return elementList;
    }

    protected NlpNoun findName_L3(List<KrmjTokenWrap> tokenWrapList1) throws Exception {
        ArrayList<KrmjTokenWrap> tokenWrapList2 = new ArrayList<KrmjTokenWrap>();
        int i = 0;
        while (i < tokenWrapList1.size()) {
            KrmjTokenWrap tokenWrap1 = tokenWrapList1.get(i);
            if (!this.isSkip(tokenWrap1)) {
                tokenWrapList2.add(tokenWrap1);
            }
            ++i;
        }
        return this.getNoun(tokenWrapList2);
    }

    protected boolean isSkip(KrmjTokenWrap tokenWrap1) throws Exception {
        if (tokenWrap1.cnt > 0) {
            return true;
        }
        return BcStringUtil.isSpace(tokenWrap1.token.getSurface());
    }

    protected abstract NlpNoun getNoun(List<KrmjTokenWrap> var1) throws Exception;
}

