/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.print;

import ext.base.log.BcLogger;
import ext.base.thread.BcMonitor;
import ext.lib.print.DcfPrintJobAttributeListener;
import ext.lib.print.DcfPrintJobLitener;
import ext.lib.print.DcfPrintUtil;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.util.Locale;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;

public class DcfPrintOutHelper {
    private DcfPrintOutHelper() {
    }

    public static DcfPrintOutHelper getInstance() {
        return SingletonHolder.instance;
    }

    public int printOut(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, Doc doc, BcLogger logger, boolean doWait) throws Exception {
        DocPrintJob docPrintJob = printService.createPrintJob();
        InnerPrintJobLitener printJobLitener = new InnerPrintJobLitener(logger);
        printJobLitener.monitor = new BcMonitor();
        printJobLitener.monitor.lock();
        docPrintJob.addPrintJobListener(printJobLitener);
        DcfPrintJobAttributeListener printJobAttributeListener = new DcfPrintJobAttributeListener(logger);
        docPrintJob.addPrintJobAttributeListener(printJobAttributeListener, null);
        int printEventType = -1;
        docPrintJob.print(doc, printRequestAttributeSet);
        if (doWait) {
            printJobLitener.monitor.sync();
            printEventType = printJobLitener.latestEvent.getPrintEventType();
        }
        return printEventType;
    }

    public int printOut(String printServiceName, String jobName, Pageable pageable, BcLogger logger, boolean doWait) throws Exception {
        PrintService printService = DcfPrintUtil.lookupPrintService(printServiceName);
        if (printService == null) {
            String msg = "\u30d7\u30ea\u30f3\u30c8\u30b5\u30fc\u30d3\u30b9 '" + printServiceName + "' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            throw new PrinterException(msg);
        }
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new JobName(jobName, Locale.getDefault()));
        printRequestAttributeSet.add(new Copies(1));
        SimpleDoc doc = new SimpleDoc(pageable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        return this.printOut(printService, printRequestAttributeSet, doc, logger, doWait);
    }

    /* synthetic */ DcfPrintOutHelper(DcfPrintOutHelper dcfPrintOutHelper) {
        this();
    }

    class InnerPrintJobLitener
    extends DcfPrintJobLitener {
        BcMonitor monitor;

        public InnerPrintJobLitener(BcLogger logger) {
            super(logger);
        }

        @Override
        protected void allDone() {
            this.monitor.unLock();
        }
    }

    private static final class SingletonHolder {
        private static final DcfPrintOutHelper instance = new DcfPrintOutHelper(null);

        private SingletonHolder() {
        }
    }
}

