/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class NimRODScrollPaneUI
extends BasicScrollPaneUI {
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent x) {
        return new NimRODScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JScrollPane sp = (JScrollPane)c;
        if (sp.getHorizontalScrollBar() != null) {
            sp.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        if (sp.getVerticalScrollBar() != null) {
            sp.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.oldOpaque = sp.isOpaque();
        sp.setOpaque(false);
        Component cc = sp.getViewport().getView();
        if (cc != null) {
            try {
                JComponent ccc = (JComponent)cc;
                if (ccc.getBorder() != null && ccc.getBorder() instanceof NimRODBorders.NimRODGenBorder) {
                    ccc.setBorder(null);
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setOpaque(this.oldOpaque);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JScrollPane sp = (JScrollPane)c;
        Dimension dim = sp.getSize();
        if (sp.getViewportBorder() != null) {
            Component cc = c.getParent();
            while (cc != null) {
                if (cc.toString().startsWith("javax.swing.plaf.basic.BasicComboPopup")) {
                    sp.setViewportBorder(null);
                    break;
                }
                cc = cc.getParent();
            }
            cc = sp.getViewport().getView();
            if (cc != null) {
                try {
                    JComponent ccc = (JComponent)cc;
                    Border bb = sp.getViewportBorder();
                    if (bb != null && bb instanceof NimRODBorders.NimRODGenBorder) {
                        int x = bb.getBorderInsets((Component)sp).left + bb.getBorderInsets((Component)sp).right - 1;
                        g.setColor(c.getBackground());
                        Graphics2D g2d = (Graphics2D)g;
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.fillRoundRect(0, 0, x + cc.getWidth(), c.getHeight(), 7, 7);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                        sp.setPreferredSize(dim);
                    }
                    if (ccc.getBorder() != null && ccc.getBorder() instanceof NimRODBorders.NimRODGenBorder) {
                        ccc.setBorder(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.paint(g, c);
    }
}

