/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformEnvelopedSignature
extends TransformSpi {
    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Element element, String string, boolean bl) throws TransformationException {
        Node node = TransformEnvelopedSignature.searchSignatureElement(element);
        xMLSignatureInput.setExcludeNode(node);
        try {
            xMLSignatureInput.addNodeFilter(new EnvelopedNodeFilter(node));
        }
        catch (XMLParserException | IOException exception) {
            throw new TransformationException(exception);
        }
        return xMLSignatureInput;
    }

    private static Node searchSignatureElement(Node node) throws TransformationException {
        boolean bl = false;
        while (node != null && node.getNodeType() != 9) {
            Element element = (Element)node;
            if (element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element.getLocalName().equals("Signature")) {
                bl = true;
                break;
            }
            node = node.getParentNode();
        }
        if (!bl) {
            throw new TransformationException("transform.envelopedSignatureTransformNotInSignatureElement");
        }
        return node;
    }

    static class EnvelopedNodeFilter
    implements NodeFilter {
        private final Node exclude;

        EnvelopedNodeFilter(Node node) {
            this.exclude = node;
        }

        @Override
        public int isNodeIncludeDO(Node node, int n) {
            if (node == this.exclude) {
                return -1;
            }
            return 1;
        }

        @Override
        public int isNodeInclude(Node node) {
            if (node == this.exclude || XMLUtils.isDescendantOrSelf(this.exclude, node)) {
                return -1;
            }
            return 1;
        }
    }
}

