/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.mscapi.CKey;
import sun.security.mscapi.CSignature;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.KeyUtil;

public final class CRSACipher
extends CipherSpi {
    private static final int ERROR_INVALID_PARAMETER = 87;
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final int PAD_PKCS1_LENGTH = 11;
    private int mode;
    private String paddingType = "PKCS1Padding";
    private int paddingLength = 0;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private CKey publicKey;
    private CKey privateKey;
    private AlgorithmParameterSpec spec = null;
    private boolean forTlsPremasterSecret = false;
    private SecureRandom random;

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase(PAD_PKCS1)) {
            throw new NoSuchPaddingException("Padding " + string + " not supported");
        }
        this.paddingType = PAD_PKCS1;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.init(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.spec = algorithmParameterSpec;
            this.random = secureRandom;
            this.forTlsPremasterSecret = true;
        } else {
            this.forTlsPremasterSecret = false;
        }
        this.init(n, key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(n, key);
    }

    private void init(int n, Key key) throws InvalidKeyException {
        boolean bl;
        switch (n) {
            case 1: 
            case 3: {
                this.paddingLength = 11;
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                this.paddingLength = 0;
                bl = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + n);
            }
        }
        if (!(key instanceof CKey)) {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths(bigInteger.bitLength() + 7 & 0xFFFFFFF8, bigInteger2, -1, 16384);
                byte[] byArray = bigInteger.toByteArray();
                byte[] byArray2 = bigInteger2.toByteArray();
                int n2 = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
                byte[] byArray3 = CSignature.RSA.generatePublicKeyBlob(n2, byArray, byArray2);
                try {
                    key = CSignature.importPublicKey("RSA", byArray3, n2);
                }
                catch (KeyStoreException keyStoreException) {
                    throw new InvalidKeyException(keyStoreException);
                }
            } else {
                throw new InvalidKeyException("Unsupported key type: " + key);
            }
        }
        if (key instanceof PublicKey) {
            this.mode = bl ? 1 : 4;
            this.publicKey = (CKey)key;
            this.privateKey = null;
            this.outputSize = this.publicKey.length() / 8;
        } else if (key instanceof PrivateKey) {
            this.mode = bl ? 3 : 2;
            this.privateKey = (CKey)key;
            this.publicKey = null;
            this.outputSize = this.privateKey.length() / 8;
        } else {
            throw new InvalidKeyException("Unknown key type: " + key);
        }
        this.bufOfs = 0;
        this.buffer = new byte[this.outputSize];
    }

    private void update(byte[] byArray, int n, int n2) {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (this.bufOfs + n2 > this.buffer.length - this.paddingLength) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    private byte[] doFinal() throws IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + (this.buffer.length - this.paddingLength) + " bytes");
        }
        try {
            byte[] byArray = this.buffer;
            switch (this.mode) {
                case 3: {
                    byte[] byArray2 = this.encryptDecrypt(byArray, this.bufOfs, this.privateKey.getHCryptKey(), true);
                    return byArray2;
                }
                case 4: {
                    byte[] byArray3 = this.encryptDecrypt(byArray, this.bufOfs, this.publicKey.getHCryptKey(), false);
                    return byArray3;
                }
                case 1: {
                    byte[] byArray4 = this.encryptDecrypt(byArray, this.bufOfs, this.publicKey.getHCryptKey(), true);
                    return byArray4;
                }
                case 2: {
                    byte[] byArray5 = this.encryptDecrypt(byArray, this.bufOfs, this.privateKey.getHCryptKey(), false);
                    return byArray5;
                }
            }
            try {
                throw new AssertionError((Object)"Internal error");
            }
            catch (KeyException | BadPaddingException generalSecurityException) {
                throw new ProviderException(generalSecurityException);
            }
        }
        finally {
            this.bufOfs = 0;
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.update(byArray, n, n2);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.update(byArray, n, n2);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException {
        this.update(byArray, n, n2);
        return this.doFinal();
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException {
        if (this.outputSize > byArray2.length - n3) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(byArray, n, n2);
        byte[] byArray3 = this.doFinal();
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        return n4;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        this.update(byArray, 0, byArray.length);
        return this.doFinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        boolean bl = string.equals("TlsRsaPremasterSecret");
        Object var5_5 = null;
        byte[] byArray2 = null;
        this.update(byArray, 0, byArray.length);
        try {
            byArray2 = this.doFinal();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Unwrapping failed", illegalBlockSizeException);
        }
        try {
            if (bl) {
                if (!this.forTlsPremasterSecret) {
                    throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
                }
                byArray2 = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)this.spec).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)this.spec).getServerVersion(), this.random, byArray2, byArray2 == null);
            }
            Key key = CRSACipher.constructKey(byArray2, string, n);
            return key;
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof CKey) {
            return ((CKey)key).length();
        }
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new InvalidKeyException("Unsupported key type: " + key);
    }

    private static PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + string + " algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct public key", invalidKeySpecException);
        }
    }

    private static PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + string + " algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot construct private key", invalidKeySpecException);
        }
    }

    private static SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    private static Key constructKey(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        switch (n) {
            case 1: {
                return CRSACipher.constructPublicKey(byArray, string);
            }
            case 2: {
                return CRSACipher.constructPrivateKey(byArray, string);
            }
            case 3: {
                return CRSACipher.constructSecretKey(byArray, string);
            }
        }
        throw new InvalidKeyException("Unknown key type " + n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] encryptDecrypt(byte[] byArray, int n, long l, boolean bl) throws KeyException, BadPaddingException {
        int[] nArray = new int[1];
        byte[] byArray2 = CRSACipher.encryptDecrypt(nArray, byArray, n, l, bl);
        if (nArray[0] == 87) {
            if (!this.forTlsPremasterSecret) throw new BadPaddingException("Error " + nArray[0] + " returned by MSCAPI");
            return null;
        }
        if (nArray[0] == 0) return byArray2;
        throw new KeyException("Error " + nArray[0] + " returned by MSCAPI");
    }

    private static native byte[] encryptDecrypt(int[] var0, byte[] var1, int var2, long var3, boolean var5) throws KeyException;
}

