/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int provides_index;
    private final int provides_with_count;
    private final int[] provides_with_index;

    ModuleProvides(DataInput file) throws IOException {
        this.provides_index = file.readUnsignedShort();
        this.provides_with_count = file.readUnsignedShort();
        this.provides_with_index = new int[this.provides_with_count];
        int i = 0;
        while (i < this.provides_with_count) {
            this.provides_with_index[i] = file.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleProvides(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.provides_index);
        file.writeShort(this.provides_with_count);
        int[] nArray = this.provides_with_index;
        int n = this.provides_with_index.length;
        int n2 = 0;
        while (n2 < n) {
            int entry = nArray[n2];
            file.writeShort(entry);
            ++n2;
        }
    }

    public String toString() {
        return "provides(" + this.provides_index + ", " + this.provides_with_count + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String interface_name = constant_pool.constantToString(this.provides_index, (byte)7);
        buf.append(Utility.compactClassName(interface_name, false));
        buf.append(", with(").append(this.provides_with_count).append("):\n");
        int[] nArray = this.provides_with_index;
        int n = this.provides_with_index.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String class_name = constant_pool.getConstantString(index, (byte)7);
            buf.append("      ").append(Utility.compactClassName(class_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

