/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.doc.shape;

import ext.base.core.BcStringUtil;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import nlc.lib.doc.shape.DcfAbstractShape;
import nlc.lib.doc.shape.DcfRectangle2D;
import nlc.lib.doc.shape.DcfShape;

public class DcfShapeGroup
extends DcfAbstractShape
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3349640930015699158L;
    protected DcfRectangle2D rectangle = new DcfRectangle2D();
    protected String label;
    protected List<DcfShape> shapeList = new ArrayList<DcfShape>();
    protected Hashtable<String, DcfShape> shapeHashtable = new Hashtable();
    protected boolean movable = true;

    public int addShape(DcfShape shape) throws Exception {
        this.shapeList.add(shape);
        if (!BcStringUtil.isEmpty(shape.getName())) {
            this.shapeHashtable.put(shape.getName(), shape);
        }
        return this.shapeList.size() - 1;
    }

    public void removeShape(DcfShape shape) throws Exception {
        this.shapeList.remove(shape);
        if (!BcStringUtil.isEmpty(shape.getName())) {
            this.shapeHashtable.remove(shape.getName());
        }
    }

    public void removeShapeAll() throws Exception {
        this.shapeList.clear();
        this.shapeHashtable.clear();
    }

    public DcfShape getShape(int index) throws Exception {
        return this.shapeList.get(index);
    }

    public DcfShape getShape(String shapeName) throws Exception {
        return this.shapeHashtable.get(shapeName);
    }

    public int getShapeCount() throws Exception {
        return this.shapeList.size();
    }

    public void setLabel(String label) throws Exception {
        this.label = label;
    }

    public String getLabel() throws Exception {
        return this.label;
    }

    public void setRectangle(Rectangle2D.Double rectangle) throws Exception {
        this.rectangle = new DcfRectangle2D(rectangle);
    }

    public void setRectangle(DcfRectangle2D rectangle) throws Exception {
        this.rectangle = rectangle;
    }

    public DcfRectangle2D getRectangle() throws Exception {
        return this.rectangle;
    }

    @Override
    public void setX(double x) throws Exception {
        this.rectangle.x = x;
    }

    @Override
    public double getX() throws Exception {
        return this.rectangle.x;
    }

    @Override
    public void setY(double y) throws Exception {
        this.rectangle.y = y;
    }

    @Override
    public double getY() throws Exception {
        return this.rectangle.y;
    }

    public void setWidth(double width) throws Exception {
        this.rectangle.width = width;
    }

    public double getWidth() throws Exception {
        return this.rectangle.width;
    }

    public void setHeight(double height) throws Exception {
        this.rectangle.height = height;
    }

    public double getHeight() throws Exception {
        return this.rectangle.height;
    }

    public void setSize(double width, double height) throws Exception {
        this.rectangle.width = width;
        this.rectangle.height = height;
    }

    public void setRect(double x, double y, double width, double height) throws Exception {
        this.rectangle.setRect(x, y, width, height);
    }

    public void setMovable(boolean movable) throws Exception {
        this.movable = movable;
    }

    public boolean getMovable() {
        return this.movable;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DcfShapeGroup obj = null;
        try {
            obj = new DcfShapeGroup();
            obj.getRectangle().x = this.rectangle.x;
            obj.getRectangle().y = this.rectangle.y;
            obj.getRectangle().width = this.rectangle.width;
            obj.getRectangle().height = this.rectangle.height;
            obj.name = this.name;
            obj.label = this.label;
            obj.movable = this.movable;
            int i = 0;
            while (i < this.getShapeCount()) {
                DcfShape shape = this.getShape(i);
                obj.addShape((DcfShape)shape.clone());
                ++i;
            }
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
        return obj;
    }
}

