/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import javax.json.JsonException;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonParsingException;
import oracle.jdbc.driver.json.OracleJsonExceptions;

public final class JsonpExceptionFactory
implements OracleJsonExceptions.ExceptionFactory {
    public static JsonpExceptionFactory INSTANCE = new JsonpExceptionFactory();

    private JsonpExceptionFactory() {
    }

    @Override
    public RuntimeException createJsonException(String message, Throwable cause) {
        return new JsonException(message, cause);
    }

    @Override
    public RuntimeException createJsonException(String message) {
        return new JsonException(message);
    }

    @Override
    public RuntimeException createGenerationException(String message, Throwable cause) {
        return new JsonGenerationException(message, cause);
    }

    @Override
    public RuntimeException createGenerationException(String message) {
        return new JsonGenerationException(message);
    }

    @Override
    public RuntimeException createParsingException(String message, Throwable cause) {
        return new JsonParsingException(message, cause, null);
    }

    @Override
    public RuntimeException createParsingException(String message) {
        return new JsonParsingException(message, null);
    }
}

