/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;

public class RowConstructor
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList exprList;
    private ArrayList<ColumnDefinition> columnDefinitions = new ArrayList();
    private String name = null;

    public ArrayList<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public boolean addColumnDefinition(ColumnDefinition columnDefinition) {
        return this.columnDefinitions.add(columnDefinition);
    }

    public ExpressionList getExprList() {
        return this.exprList;
    }

    public void setExprList(ExpressionList exprList) {
        this.exprList = exprList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        if (this.columnDefinitions.size() > 0) {
            StringBuilder builder = new StringBuilder(this.name != null ? this.name : "");
            builder.append("(");
            int i = 0;
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                builder.append(i > 0 ? ", " : "").append(columnDefinition.toString());
                ++i;
            }
            builder.append(")");
            return builder.toString();
        }
        return (this.name != null ? this.name : "") + this.exprList.toString();
    }

    public RowConstructor withExprList(ExpressionList exprList) {
        this.setExprList(exprList);
        return this;
    }

    public RowConstructor withName(String name) {
        this.setName(name);
        return this;
    }
}

