/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public class BootstrapMethods
extends Attribute {
    private BootstrapMethod[] bootstrap_methods;

    public BootstrapMethods(BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(int name_index, int length, BootstrapMethod[] bootstrap_methods, ConstantPool constant_pool) {
        super((byte)20, name_index, length, constant_pool);
        this.bootstrap_methods = bootstrap_methods;
    }

    BootstrapMethods(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        int num_bootstrap_methods = input.readUnsignedShort();
        this.bootstrap_methods = new BootstrapMethod[num_bootstrap_methods];
        int i = 0;
        while (i < num_bootstrap_methods) {
            this.bootstrap_methods[i] = new BootstrapMethod(input);
            ++i;
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        return this.bootstrap_methods;
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrap_methods) {
        this.bootstrap_methods = bootstrap_methods;
    }

    @Override
    public void accept(Visitor v) {
        v.visitBootstrapMethods(this);
    }

    @Override
    public BootstrapMethods copy(ConstantPool _constant_pool) {
        BootstrapMethods c = (BootstrapMethods)this.clone();
        c.bootstrap_methods = new BootstrapMethod[this.bootstrap_methods.length];
        int i = 0;
        while (i < this.bootstrap_methods.length) {
            c.bootstrap_methods[i] = this.bootstrap_methods[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.bootstrap_methods.length);
        BootstrapMethod[] bootstrapMethodArray = this.bootstrap_methods;
        int n = this.bootstrap_methods.length;
        int n2 = 0;
        while (n2 < n) {
            BootstrapMethod bootstrap_method = bootstrapMethodArray[n2];
            bootstrap_method.dump(file);
            ++n2;
        }
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BootstrapMethods(");
        buf.append(this.bootstrap_methods.length);
        buf.append("):");
        int i = 0;
        while (i < this.bootstrap_methods.length) {
            buf.append("\n");
            int start = buf.length();
            buf.append("  ").append(i).append(": ");
            int indent_count = buf.length() - start;
            String[] lines = this.bootstrap_methods[i].toString(super.getConstantPool()).split("\\r?\\n");
            buf.append(lines[0]);
            int j = 1;
            while (j < lines.length) {
                buf.append("\n").append("          ".substring(0, indent_count)).append(lines[j]);
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }
}

