/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.base.Disposable;
import com.oracle.common.internal.Platform;
import com.oracle.common.internal.net.ipclw.mql.Context;
import com.oracle.common.internal.net.ipclw.mql.KeyRegistry;
import com.oracle.common.internal.net.ipclw.mql.KeyedBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedMultiBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedSingleBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import com.oracle.common.internal.net.ipclw.mql.MessageQueue;
import com.oracle.common.internal.net.ipclw.mql.MultiInterfaceKeyRegistry;
import com.oracle.common.internal.net.ipclw.mql.RegistrationKey;
import com.oracle.common.internal.net.ipclw.mql.RemoteQueue;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.net.InetAddresses;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.AbstractAdapter;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MQLFlowControl;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NTMQProtocolHandler;
import oracle.net.nt.TimeoutInterruptHandler;

public class MQLNTAdapter
extends AbstractAdapter
implements LocalQueue.ReadCallback {
    private static final String CLASS_NAME = MQLNTAdapter.class.getName();
    private SocketChannel socketChannel;
    private Selector selector;
    private SelectionKey selectionKey;
    private long connectTimeout;
    protected Socket socket;
    protected int readTimeout;
    protected Properties socketOptions;
    private InetSocketAddress inetSocketAddress;
    private final AtomicInteger numberOfMessagesReceived = new AtomicInteger(0);
    private final ByteBuffer wakeupBuffer = ByteBuffer.allocateDirect(1);
    InetAddress localInetAddress;
    private Context mqContext;
    private LocalQueue localQueue;
    private RemoteQueue remoteQueue;
    private static BufferManager bufferManager = null;
    Context.Dependencies.Transport transport = null;
    int busyWait;
    int kernelWait;
    IOException ioExceptionWhileMSGQOp = null;
    Queue<BufferSequence> onMessageBufferList = new LinkedList<BufferSequence>();
    BufferSequence dequedRcvBuf = null;
    NTMQProtocolHandler ntmqProtocolHandler;
    private int headerSizeSend;
    private int sdu = 65518;
    private int tdu = 65536;
    private boolean drainBuffers = false;
    private boolean flowControlEnabled = false;
    private MQLFlowControl flowControl;
    private static final boolean FLOW_CONTROL_ENABLED = true;
    private KeyRegistry keyRegistry;
    private int kernelWaitSend = Integer.MAX_VALUE;
    private int kernelWaitWork = Integer.MAX_VALUE;
    private TimeoutInterruptHandler.InterruptTask interruptTask;
    private byte[] sessionId = null;
    private boolean isConnected = false;
    private int pendingSends;
    private BufferSequence sendOnInterrupt = null;
    private boolean connectResponsePending;
    private int postCount = 0;
    private static final byte MQL_RC_TRANS = 1;
    private static final int MQL_DEFAULT_BUFFER_SPACE = 8;
    private static final int MQL_MAX_MSGSIZE = 65536;
    private static final int IMD_MSG_BUFFER_SPACE = 2;
    private static final int IMD_MAX_MSGSIZE = 65536;
    private static final int MAX_PENDING = 4;
    private static final int USR_WAIT_WORK = 10000;
    private static final int USR_WAIT_SEND = 10000;
    private static final int RDMA_CONNECT_WAIT = 2000;
    private static final int RCV_BUF_COUNT = 1;
    private static final int SEND_BUF_COUNT = 2;
    private static final int HDR_OFFSET_SEND = 0;
    private static final int NS_OFFSET_SEND = 1;
    private static final String FMW_COMMONS_IP_PROP = "com.oracle.common.internal.net.ipclw.mql.Context.defaultAddress";
    private static final String MSGQ_ERR_STATE_MSG = "Message Queue is in an error state.";
    ByteBuffer bufferForDeathDetection = ByteBuffer.allocate(1);
    private static final Monitor BUFFER_MANAGER_INIT_MONITOR = Monitor.newInstance();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static BufferManager getBufferManager() {
        return bufferManager;
    }

    public MQLNTAdapter(String address, ConnOption connOption, @Blind(value=PropertiesBlinder.class) Properties socketOptions) throws NLException {
        this.socketOptions = socketOptions;
        this.inetSocketAddress = connOption.inetSocketAddress;
        this.host = connOption.host;
        this.port = connOption.port;
        this.ntmqProtocolHandler = new NTMQProtocolHandler(1, false, false);
        String msgqTransport = (String)socketOptions.get(22);
        if (msgqTransport != null) {
            this.transport = Context.Dependencies.Transport.valueOf((String)msgqTransport);
        }
        this.busyWait = Integer.parseInt((String)socketOptions.get(23));
        this.kernelWait = Integer.parseInt((String)socketOptions.get(24));
        CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.CONFIG, CLASS_NAME, "MQLNTAdapter", "host={0}, port={1}, transport={2}, socketOptions={3}. ", (String)null, null, (Object)this.host, (Object)this.port, (Object)this.transport, (Object)socketOptions);
    }

    private void handleConnectPacket() throws IOException {
        if (!this.connectResponsePending) {
            throw new NetException(17826, "Received unexpected packet type: 1");
        }
        this.connectResponsePending = false;
        if (this.ntmqProtocolHandler.isSIDRequiredForRqMsg()) {
            this.sessionId = this.ntmqProtocolHandler.getSID();
            this.headerSizeSend = 18;
        } else {
            this.sessionId = null;
            this.headerSizeSend = 2;
        }
        ByteBuffer nameBuffer = this.ntmqProtocolHandler.getRemoteQueueNameBuffer();
        MessageQueue.Name remoteQueueName = new MessageQueue.Name(nameBuffer);
        this.initRemoteQueue();
        this.remoteQueue.connect(remoteQueueName);
        this.flowControlEnabled = this.ntmqProtocolHandler.isFlowControlEnabled();
        if (this.flowControlEnabled) {
            BufferSequence interruptMsg = this.ntmqProtocolHandler.isSIDRequiredForRdmaMsg() ? this.createMqlMessage((byte)6, (byte)4, this.ntmqProtocolHandler.getSID(), true) : this.createMqlMessage((byte)6, (byte)0, null, true);
            short initialBufferCount = this.ntmqProtocolHandler.getFcPostCount();
            this.flowControl.onFlowControlEnabled(initialBufferCount, this.ntmqProtocolHandler.getFcKey(), this.ntmqProtocolHandler.getFcAddr(), this.remoteQueue, interruptMsg);
            this.flowControl.onMessageReceived();
            this.flowControl.onBufferPosted(this.postCount);
            BufferSequence msg = this.createMqlMessage((byte)6, (byte)0);
            this.writeToRemoteQueue(msg);
            while (this.flowControl.getAvailableBufferCount() != initialBufferCount) {
                this.await(this.localQueue.getContext(), 0, 2000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocalQueueNameOnSocket(LocalQueue localQueue) throws IOException {
        ByteBuffer headerPacket = bufferManager.acquire(this.ntmqProtocolHandler.getHeaderPacketSize());
        this.ntmqProtocolHandler.prepareHeaderPacket(headerPacket, (byte)1, (byte)1, this.sessionId, false);
        int connectPacketSize = 28 + this.mqContext.getNameSize() + 12 + this.mqContext.getKeySize();
        ByteBuffer connectPacket = bufferManager.acquire(connectPacketSize);
        this.ntmqProtocolHandler.prepareConnectPacket(connectPacket, null, this.sdu, ByteOrder.LITTLE_ENDIAN, localQueue);
        this.prepareFlowControlPacket(connectPacket);
        ByteBuffer ntmqPacket = bufferManager.acquire(headerPacket.limit() + connectPacket.limit());
        ntmqPacket.order(ByteOrder.LITTLE_ENDIAN);
        ntmqPacket.put(headerPacket);
        ntmqPacket.put(connectPacket);
        ntmqPacket.flip();
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.INTERNAL, CLASS_NAME, "writeLocalQueueNameOnSocket", "ntmqPacket.hasRemaining()={0}. ", (String)null, null, (Object)ntmqPacket.hasRemaining());
        try {
            this.selectionKey.interestOps(4);
            while (ntmqPacket.hasRemaining()) {
                if (this.selector.select(this.readTimeout) == 0) {
                    throw new NetException(17823);
                }
                Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    if (key.isWritable()) {
                        int writtenBytes = this.socketChannel.write(ntmqPacket);
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.INTERNAL, CLASS_NAME, "writeLocalQueueNameOnSocket", "writtenBytes={0}. ", (String)null, null, (Object)writtenBytes);
                    }
                    keyIterator.remove();
                }
            }
        }
        catch (ClosedByInterruptException cbiEx) {
            this.handleInterrupt();
        }
        finally {
            bufferManager.release(ntmqPacket);
            bufferManager.release(connectPacket);
            bufferManager.release(headerPacket);
        }
        this.connectResponsePending = true;
    }

    public ByteBuffer readFromLocalQueue() throws IOException {
        return this.readFromLocalQueue(true);
    }

    public ByteBuffer readFromLocalQueue(boolean blocking) throws IOException {
        ByteBuffer nsBuffer;
        this.ensureConnection(false);
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.INTERNAL, CLASS_NAME, "readFromLocalQueue", "reading from local queue. blocking={0}. ", (String)null, null, (Object)blocking);
        do {
            BufferSequence nextMsg = this.getNextMessage(blocking);
            if (this.dequedRcvBuf != null) {
                this.dequedRcvBuf.dispose();
            }
            this.dequedRcvBuf = nextMsg;
            if (nextMsg == null) {
                return null;
            }
            nsBuffer = nextMsg.getBuffer(0);
            this.processNTMQLayer(nsBuffer);
        } while (!this.ntmqProtocolHandler.isDataPacket());
        int dataLen = nsBuffer.remaining();
        nsBuffer.limit(nsBuffer.position() + this.sdu);
        nsBuffer = nsBuffer.slice();
        nsBuffer.limit(dataLen);
        return nsBuffer;
    }

    private BufferSequence getNextMessage(boolean blocking) throws IOException {
        while (this.onMessageBufferList.size() <= 0) {
            this.readNTMQPacketFromLocalQueue(blocking);
            if (blocking) continue;
            break;
        }
        return this.onMessageBufferList.poll();
    }

    private void readNTMQPacketFromLocalQueue(boolean blocking) throws IOException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.INTERNAL, CLASS_NAME, "readNTMQPacketFromLocalQueue", "calling await. blocking={0}. ", (String)null, null, (Object)blocking);
        int numberOfWaits = 0;
        try {
            this.scheduleInterrupt(this.readTimeout);
            while (this.numberOfMessagesReceived.get() == 0 || this.mqContext.isWorkPending()) {
                this.replenish();
                if (this.remoteQueue != null && this.remoteQueue.getContext().isWorkPending()) {
                    this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                } else if (blocking) {
                    this.await(this.localQueue.getContext(), numberOfWaits == 0 ? this.busyWait : 0, this.kernelWait);
                } else {
                    this.await(this.remoteQueue.getContext(), 0, 0);
                    break;
                }
                if (this.numberOfMessagesReceived.get() != 0 || numberOfWaits++ <= 5 || !this.isConnectionDead()) continue;
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.STATIC, CLASS_NAME, "readNTMQPacketFromLocalQueue", "isConnectionDead returns true.", null, null);
                this.disconnect();
                throw new NetException(17800);
            }
        }
        finally {
            this.cancelTimeout();
        }
        this.numberOfMessagesReceived.set(0);
        if (this.flowControlEnabled) {
            this.flowControl.sendCounterUpdate();
        }
    }

    private void processNTMQLayer(ByteBuffer ntmqPacket) throws IOException {
        this.ntmqProtocolHandler.processNTMQPacket(ntmqPacket);
        if (this.ntmqProtocolHandler.isDisconnectPacket()) {
            this.writeLocalQueueNameOnSocket(this.localQueue);
        } else if (this.ntmqProtocolHandler.isConnectPacket()) {
            this.handleConnectPacket();
        } else if (this.ntmqProtocolHandler.isDataIRPacket()) {
            this.flowControl.onIRMessage(this.ntmqProtocolHandler.getPacketFlag());
        }
    }

    public int writeToRemoteQueue(ByteBuffer sendBuffer, boolean releaseBuffer) throws IOException {
        this.ensureConnection(true);
        int pos = sendBuffer.limit();
        KeyedBufferSequence bufseqMsgToWrite = this.initSendBuffer((byte)4, (byte)0, sendBuffer, releaseBuffer);
        if (CommonDiagnosable.getInstance().isLoggable(Level.FINEST)) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.INTERNAL, CLASS_NAME, "writeToRemoteQueue", "bufseqMsgToWrite initialized", "bufseqMsgToWrite initialized, HeaderBuffer:\n{0} \nPacketBuffer:\n{1}", null, (Object)MQLNTAdapter.dump(bufseqMsgToWrite.getBuffer(0)), (Object)MQLNTAdapter.dump(sendBuffer));
        }
        this.writeToRemoteQueue((BufferSequence)bufseqMsgToWrite);
        return pos;
    }

    private void writeToRemoteQueue(BufferSequence bufseqMsgToWrite) throws IOException {
        this.writeToRemoteQueue(bufseqMsgToWrite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToRemoteQueue(BufferSequence bufseqMsgToWrite, boolean canAwait) throws IOException {
        block14: {
            if (this.flowControlEnabled) {
                if (!this.ensureAvailableReceiveSpace(bufseqMsgToWrite, canAwait)) {
                    return canAwait;
                }
                this.flowControl.onMessageSent();
            }
            if (this.pendingSends >= 4) {
                if (canAwait) {
                    while (this.pendingSends >= 4) {
                        this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                    }
                } else {
                    return false;
                }
            }
            try {
                this.scheduleInterrupt(this.readTimeout);
                ++this.pendingSends;
                if (canAwait) {
                    try {
                        while (!this.remoteQueue.send(bufseqMsgToWrite, (Object)bufseqMsgToWrite, 1)) {
                            this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitSend);
                        }
                        break block14;
                    }
                    catch (IOException ioex) {
                        --this.pendingSends;
                        throw ioex;
                    }
                }
                if (!this.remoteQueue.send(bufseqMsgToWrite, (Object)bufseqMsgToWrite, 1)) {
                    --this.pendingSends;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.cancelTimeout();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureAvailableReceiveSpace(BufferSequence nextMsgToSend, boolean canAwait) throws IOException {
        int availableBufferCount = this.flowControl.getAvailableBufferCount();
        if (availableBufferCount == 0) {
            if (this.sendOnInterrupt != null || !canAwait) {
                return false;
            }
            this.sendOnInterrupt = nextMsgToSend;
            try {
                while (availableBufferCount == 0) {
                    this.await(this.localQueue.getContext(), 0, this.kernelWait);
                    if (this.sendOnInterrupt == null) {
                        boolean bl = false;
                        return bl;
                    }
                    availableBufferCount = this.flowControl.getAvailableBufferCount();
                }
            }
            finally {
                this.sendOnInterrupt = null;
            }
        }
        if (availableBufferCount == 1) {
            ByteBuffer nextMsgHeader = nextMsgToSend.getBuffer(0);
            if (nextMsgHeader.get(0) == 4) {
                this.wakeupBuffer.put(0, (byte)0);
                if (!this.flowControl.sendInterruptRequest(canAwait)) {
                    return false;
                }
                if (this.ioExceptionWhileMSGQOp != null) {
                    throw this.ioExceptionWhileMSGQOp;
                }
                this.ntmqProtocolHandler.prepareHeaderPacket(nextMsgHeader, (byte)7, this.flowControl.getInterruptRequestCount(), this.sessionId, false);
            } else {
                if (!canAwait) {
                    return false;
                }
                while (availableBufferCount <= 1) {
                    this.await(this.remoteQueue.getContext(), 0, this.kernelWait);
                    availableBufferCount = this.flowControl.getAvailableBufferCount();
                }
            }
        }
        return true;
    }

    private void await(Context context, int usrWaitMicro, int sysWaitMilli) throws IOException {
        if (this.ioExceptionWhileMSGQOp != null) {
            throw (IOException)new IOException(MSGQ_ERR_STATE_MSG).initCause(this.ioExceptionWhileMSGQOp);
        }
        this.wakeupBuffer.put(0, (byte)0);
        context.await(usrWaitMicro, sysWaitMilli);
        if (this.ioExceptionWhileMSGQOp != null) {
            throw this.ioExceptionWhileMSGQOp;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterrupt();
        }
    }

    private KeyedBufferSequence initSendBuffer(byte packetType, byte packetFlags, ByteBuffer payloadBuffer, boolean releaseOnSend) throws IOException {
        ByteBuffer[] writeMsgBuffers = new ByteBuffer[2];
        RegistrationKey[] writeMsgKeys = new RegistrationKey[2];
        final ByteBuffer[] bufAcquired = new ByteBuffer[2];
        ByteBuffer headerBufferToWrite = bufferManager.acquire(this.headerSizeSend);
        RegistrationKey headerBufferKey = this.keyRegistry.getKey(headerBufferToWrite);
        this.ntmqProtocolHandler.prepareHeaderPacket(headerBufferToWrite, packetType, packetFlags, this.sessionId, false);
        writeMsgBuffers[0] = headerBufferToWrite;
        writeMsgKeys[0] = headerBufferKey;
        bufAcquired[0] = headerBufferToWrite;
        if (payloadBuffer.isDirect() && (writeMsgKeys[1] = this.keyRegistry.getKey(payloadBuffer)) != null) {
            writeMsgBuffers[1] = payloadBuffer;
            if (releaseOnSend) {
                bufAcquired[1] = writeMsgBuffers[1];
            }
        } else {
            ByteBuffer copyBuffer = bufferManager.acquire(payloadBuffer.remaining());
            copyBuffer.put(payloadBuffer);
            copyBuffer.flip();
            writeMsgBuffers[1] = copyBuffer;
            writeMsgKeys[1] = this.keyRegistry.getKey(copyBuffer);
            bufAcquired[1] = copyBuffer;
        }
        return new KeyedMultiBufferSequence(null, writeMsgBuffers, null, writeMsgKeys){
            private final ByteBuffer[] toRelease;
            {
                super(x0, x1, x2, x3);
                this.toRelease = bufAcquired;
            }

            public void dispose() {
                MQLNTAdapter.this.pendingSends--;
                for (ByteBuffer buf : this.toRelease) {
                    if (buf == null) continue;
                    bufferManager.release(buf);
                }
            }
        };
    }

    private void initLocalQueue(Context.DefaultDependencies dependencies) throws IOException {
        this.mqContext.setWakeupBuffer(this.wakeupBuffer);
        LocalQueue.DefaultDependencies localQueueDep = new LocalQueue.DefaultDependencies(dependencies, null).setMaximumReceiveMessageCount(8).setMaximumMessageSizeBytes(65536).setMaximumMessageBufferCount(1);
        localQueueDep.setInitialReceiveMessageCount(0);
        this.localQueue = this.mqContext.openLocalQueue((LocalQueue.Dependencies)localQueueDep);
        this.localQueue.setReadCallback((LocalQueue.ReadCallback)this);
        this.localQueue.getContext().setRdmaImmediateCallback(new LocalQueue.ReadCallback(){

            public void onMessage(BufferSequence immediateMsg, IOException ioex) throws IOException {
                immediateMsg.dispose();
                if (ioex != null) {
                    if (MQLNTAdapter.this.ioExceptionWhileMSGQOp != null) {
                        ioex.initCause(MQLNTAdapter.this.ioExceptionWhileMSGQOp);
                    }
                    MQLNTAdapter.this.ioExceptionWhileMSGQOp = ioex;
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                } else if (MQLNTAdapter.this.sendOnInterrupt != null && MQLNTAdapter.this.writeToRemoteQueue(MQLNTAdapter.this.sendOnInterrupt, false)) {
                    MQLNTAdapter.this.sendOnInterrupt = null;
                } else {
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
            }
        });
        this.localQueue.bind();
        this.replenish();
    }

    private BufferSequence initReceiveBuffer() throws IOException {
        ByteBuffer buffer = bufferManager.acquire(this.tdu);
        RegistrationKey key = this.keyRegistry.getKey(buffer);
        return new KeyedSingleBufferSequence(bufferManager, buffer, null, key);
    }

    private BufferSequence createMqlMessage(byte type, byte flags) throws IOException {
        return this.createMqlMessage(type, flags, null, false);
    }

    private BufferSequence createMqlMessage(byte type, byte flags, byte[] sid, final boolean immediateMsg) throws IOException {
        int headerSize = immediateMsg && this.ntmqProtocolHandler.isSIDRequiredForRdmaMsg() ? 18 : this.headerSizeSend;
        ByteBuffer mqlHeader = bufferManager.acquire(headerSize);
        this.ntmqProtocolHandler.prepareHeaderPacket(mqlHeader, type, flags, sid, immediateMsg);
        RegistrationKey key = this.keyRegistry.getKey(mqlHeader);
        return new KeyedSingleBufferSequence(bufferManager, mqlHeader, null, key){
            boolean isImmediateMsg;
            {
                super(x0, x1, x2, x3);
                this.isImmediateMsg = immediateMsg;
            }

            public void dispose() {
                if (!this.isImmediateMsg) {
                    MQLNTAdapter.this.pendingSends--;
                }
                super.dispose();
            }
        };
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException {
        try {
            this.connectSocket();
            this.isConnected = true;
        }
        catch (ClosedByInterruptException cbiEx) {
            this.handleInterrupt();
        }
        this.setSocketOptions();
        String localIpStr = (String)this.socketOptions.get(21);
        this.localInetAddress = localIpStr != null ? InetAddress.getByName(localIpStr) : InetAddresses.getLocalHost();
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.CONFIG, CLASS_NAME, "connect", "using localInetAddress={0}. ", (String)null, null, (Object)this.localInetAddress);
        this.initBufferManager(this.localInetAddress);
        this.keyRegistry = ((MultiInterfaceKeyRegistry)bufferManager).getRegistry(this.localInetAddress);
        Context.DefaultDependencies dependencies = new Context.DefaultDependencies().setInetAddress(this.localInetAddress).setBufferManager(bufferManager).setMaximumOutstandingMessageCount(4).setMaximumMessageSizeBytes(65536).setParentContext(this.keyRegistry.getContext()).setTransport(Context.Dependencies.Transport.RC).setFlags(5).setMaximumImmediateReceiveMessageCount(2).setMaximumImmediateReceiveMessageSizeBytes(65536);
        if (this.transport != null) {
            dependencies.setTransport(this.transport);
        }
        this.mqContext = new Context((Context.Dependencies)dependencies);
        this.mqContext.open();
        this.initLocalQueue(dependencies);
        this.connectToRemoteQueue();
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.STATIC, CLASS_NAME, "connect", "remote queue connected. ", null, null);
    }

    private void connectSocket() throws IOException {
        Boolean useNio = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!useNio.booleanValue()) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.STATIC, CLASS_NAME, "connectSocket", "NIO is required. ", null, null);
            throw new NetException(17820);
        }
        String c_timeout = (String)this.socketOptions.get(2);
        this.connectTimeout = Integer.parseInt(c_timeout);
        try {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.CONFIG, CLASS_NAME, "connectSocket", "Inet = {0}, Port = {1}, Timeout = {2}", (String)null, null, (Object)this.inetSocketAddress.getHostString(), (Object)this.port, (Object)c_timeout);
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(false);
            this.selector = Selector.open();
            this.selectionKey = this.socketChannel.register(this.selector, 8);
            this.socketChannel.connect(this.inetSocketAddress);
            if (this.selector.select(this.connectTimeout) == 0) {
                throw new NetException(17822);
            }
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
            while (keyIterator.hasNext()) {
                SelectionKey key = keyIterator.next();
                if (key.isConnectable()) {
                    while (!this.socketChannel.finishConnect()) {
                    }
                } else {
                    throw new NetException(17824);
                }
                keyIterator.remove();
            }
            this.socket = this.socketChannel.socket();
        }
        catch (IOException ea) {
            DownHostsCache.getInstance().markDownHost(this.inetSocketAddress.getAddress(), this.port);
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "connectSocket", "Connection failed {0}", (String)null, null, (Object)ea);
            if (this.selectionKey != null) {
                this.selectionKey.cancel();
            }
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                }
            }
            catch (Exception e2) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connectSocket", "Ignoring SocketChannel Close Exception {0}", (String)null, null, (Object)e2);
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e2) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connectSocket", "Ignoring Socket Close Exception {0}", (String)null, null, (Object)e2);
            }
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (Exception e2) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connectSocket", "Ignoring Selectore Exception {0}", (String)null, null, (Object)e2);
            }
            throw ea;
        }
    }

    private void connectToRemoteQueue() throws IOException {
        try {
            if (!this.connectResponsePending) {
                this.writeLocalQueueNameOnSocket(this.localQueue);
            }
            do {
                BufferSequence nextMessage = this.getNextMessage(true);
                ByteBuffer packet = nextMessage.getBuffer(0);
                this.processNTMQLayer(packet);
                nextMessage.dispose();
                if (!this.ntmqProtocolHandler.isDataPacket()) continue;
                throw new NetException(17826, "ConnectPacket was expected");
            } while (!this.ntmqProtocolHandler.isConnectPacket());
        }
        catch (InterruptedIOException iioEx) {
            throw new NetException(17823);
        }
    }

    public void setSocketOptions() throws IOException {
        String temp = (String)this.socketOptions.get(0);
        if (temp != null) {
            this.setOption(0, temp);
        }
        if ((temp = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        if (this.remoteQueue != null) {
            try {
                while (this.remoteQueue.isWorkPending()) {
                    this.await(this.remoteQueue.getContext(), 10000, this.kernelWaitWork);
                }
            }
            catch (IOException ioex) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error flushing sends on disconnect: {0}. ", (String)null, null, (Object)ioex);
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.STATIC, CLASS_NAME, "disconnect", "Attempting to close remoteQueue: start. ", null, null);
            try {
                this.remoteQueue.close();
            }
            catch (IOException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the remote queue: {0}. ", (String)null, null, (Object)e);
            }
            finally {
                this.remoteQueue = null;
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempting to close remoteQueue: complete. ", null, null);
        }
        if (this.localQueue != null) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempting to close localQueue: start. ", null, null);
            try {
                this.localQueue.close();
            }
            catch (IOException ioex) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the local queue: {0}. ", (String)null, null, (Object)ioex);
            }
            finally {
                this.localQueue = null;
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempting to close localQueue: complete. ", null, null);
        }
        if (this.flowControl != null) {
            this.flowControl.onDisconnect(this.mqContext);
            this.flowControl = null;
        }
        if (this.dequedRcvBuf != null) {
            this.dequedRcvBuf.dispose();
            this.dequedRcvBuf = null;
        }
        if (this.socketChannel != null) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close socketChannel: start. ", null, null);
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the socket channel: {0}. ", (String)null, null, (Object)e);
            }
            finally {
                this.socketChannel = null;
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close socketChannel: complete. ", null, null);
        }
        if (this.socket != null) {
            try {
                if (!this.socket.isClosed()) {
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close socket: start. ", null, null);
                    this.socket.close();
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close socket: complete. ", null, null);
                }
            }
            catch (IOException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the socket: {0}. ", (String)null, null, (Object)e);
            }
            finally {
                this.socket = null;
            }
        }
        if (this.selector != null) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close selector: start. ", null, null);
            try {
                this.selector.close();
            }
            catch (IOException e) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the selector. ", null, e);
            }
            finally {
                this.selector = null;
            }
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Attempt to close selector: complete. ", null, null);
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "NT TCP connection terminated. ", null, null);
        if (this.mqContext != null) {
            try {
                this.mqContext.close();
            }
            catch (IOException ioex) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disconnect", "Error closing the MQL Context. ", null, ioex);
            }
        }
        this.isConnected = false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(17900);
        }
        switch (option) {
            case 0: {
                String tmp = (String)value;
                this.socket.setTcpNoDelay(tmp.equals("YES"));
                break;
            }
            case 1: {
                String tmp = (String)value;
                if (!tmp.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: 
            case 101: {
                this.readTimeout = Integer.parseInt((String)value);
                this.socket.setSoTimeout(this.readTimeout);
                this.kernelWaitWork = this.readTimeout == 0 ? Integer.MAX_VALUE : this.readTimeout;
                this.kernelWaitSend = this.kernelWaitWork;
                break;
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(17900);
        }
        switch (option) {
            case 101: {
                return "" + this.readTimeout;
            }
            case 3: {
                return Integer.toString(this.socket.getSoTimeout());
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
        ByteBuffer echoPacket = ByteBuffer.allocate(2);
        this.ntmqProtocolHandler.prepareHeaderPacket(echoPacket, (byte)5, (byte)0, null, false);
        this.socketChannel.write(echoPacket);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return null;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.MSGQ;
    }

    public void onMessage(BufferSequence bufseq, IOException ioex) throws IOException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "onMessage", "LocalQueue onMessage callback. ", null, null);
        if (ioex != null) {
            if (this.ioExceptionWhileMSGQOp != null) {
                ioex.initCause(this.ioExceptionWhileMSGQOp);
            }
            this.ioExceptionWhileMSGQOp = ioex;
        }
        this.onMessageBufferList.add(bufseq);
        this.numberOfMessagesReceived.incrementAndGet();
        if (this.flowControlEnabled) {
            this.flowControl.onMessageReceived();
        } else {
            this.wakeupBuffer.put(0, (byte)1);
        }
        this.replenish();
    }

    private boolean isConnectionDead() throws IOException {
        if (!this.socketChannel.isOpen()) {
            return true;
        }
        if (this.socket.isClosed()) {
            return true;
        }
        if (this.socket.isInputShutdown()) {
            return true;
        }
        if (this.socket.isOutputShutdown()) {
            return true;
        }
        this.selectionKey.interestOps(1);
        if (this.selector.selectNow() > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
            while (keyIterator.hasNext()) {
                SelectionKey key = keyIterator.next();
                if (key.isReadable()) {
                    int bytesRead = this.socketChannel.read(this.bufferForDeathDetection);
                    if (bytesRead == -1) {
                        return true;
                    }
                    if (bytesRead > 0) {
                        throw new NetException(17824);
                    }
                }
                keyIterator.remove();
            }
        }
        return false;
    }

    public void setNegotiatedSDUAndTDU(int sdu, int tdu) {
        this.sdu = sdu;
        int adjustedTDU = Math.max(tdu, sdu + 18);
        if (this.tdu != adjustedTDU) {
            this.tdu = adjustedTDU;
            this.drainBuffers = true;
        }
    }

    private int replenish() throws IOException {
        if (this.onMessageBufferList.size() >= 8) {
            return 0;
        }
        int bufCount = this.localQueue.getAvailableReceiveSpaceMessageCount();
        if (this.drainBuffers) {
            if (bufCount > 0) {
                return 0;
            }
            this.drainBuffers = false;
        }
        int more = 8 - bufCount;
        int added = 0;
        if (more > 0) {
            BufferSequence[] receiveBuffers = new BufferSequence[more];
            for (int i = 0; i < more; ++i) {
                receiveBuffers[i] = this.initReceiveBuffer();
            }
            added = this.localQueue.addMessageBuffers(receiveBuffers, 0, more);
            if (added < more) {
                for (BufferSequence failedToAdd : receiveBuffers) {
                    if (failedToAdd == null) continue;
                    failedToAdd.dispose();
                }
            }
            if (added > 0) {
                if (this.flowControlEnabled) {
                    this.flowControl.onBufferPosted(added);
                }
                this.postCount += added;
            }
        }
        return added;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    private void prepareFlowControlPacket(ByteBuffer connectPacket) throws IOException {
        if (this.flowControl == null) {
            this.flowControl = new MQLFlowControl(this.localQueue.getContext(), this.keyRegistry.getContext());
        }
        short availableBuffers = (short)this.localQueue.getAvailableReceiveSpaceMessageCount();
        if (this.ntmqProtocolHandler.getPacketType() == 2 && this.ntmqProtocolHandler.getPacketFlag() == 8) {
            availableBuffers = (short)(availableBuffers - 1);
        }
        this.flowControl.setLocalPostCount(availableBuffers);
        this.flowControl.resetLocalFCB();
        RegistrationKey fcbKey = this.flowControl.getLocalFCBKey();
        this.ntmqProtocolHandler.appendFlowControlPacket(connectPacket, true, availableBuffers, fcbKey.getRemoteVirtualAddress(), fcbKey.getKeyBuffer());
        this.postCount = 0;
    }

    private void scheduleInterrupt(int timeout) {
        if (timeout > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, timeout, Thread.currentThread());
        }
    }

    private void handleInterrupt() throws IOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("MSGQ read timed out");
        }
        throw new InterruptedIOException("Operation interrupted");
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    private void initBufferManager(InetAddress ipOfIB) throws IOException {
        block16: {
            if (bufferManager != null) {
                return;
            }
            try (Monitor.CloseableLock lock = BUFFER_MANAGER_INIT_MONITOR.acquireCloseableLock();){
                BufferManager tmpBufferManager;
                if (bufferManager != null) break block16;
                if (null == System.getProperty(FMW_COMMONS_IP_PROP)) {
                    System.setProperty(FMW_COMMONS_IP_PROP, ipOfIB.getHostAddress());
                }
                if ((tmpBufferManager = BufferManagers.getNetworkDirectManager()) instanceof MultiInterfaceKeyRegistry) {
                    bufferManager = tmpBufferManager;
                    break block16;
                }
                if (!Platform.getPlatform().isExaEnabled()) {
                    throw new IOException("This system is not recognized as an Exadirect enabled platform.");
                }
                throw new IOException("IP: " + ipOfIB.getHostAddress() + " is not recognized as an RDMA enabled adapter.");
            }
        }
    }

    private void ensureConnection(boolean writeOp) throws IOException {
        if (this.ioExceptionWhileMSGQOp != null) {
            throw (IOException)new IOException(MSGQ_ERR_STATE_MSG).initCause(this.ioExceptionWhileMSGQOp);
        }
        if (writeOp && this.connectResponsePending) {
            this.connectToRemoteQueue();
        }
        if (!this.isConnected) {
            throw new NetException(17900);
        }
    }

    private void initRemoteQueue() throws IOException {
        if (this.remoteQueue != null) {
            this.remoteQueue.close();
        }
        this.remoteQueue = this.mqContext.openRemoteQueue();
        this.remoteQueue.setWriteCallback(new RemoteQueue.WriteCallback(){

            public void onCompletion(Object oCookie, IOException e) {
                if (e != null) {
                    if (MQLNTAdapter.this.ioExceptionWhileMSGQOp != null) {
                        e.initCause(MQLNTAdapter.this.ioExceptionWhileMSGQOp);
                    }
                    MQLNTAdapter.this.ioExceptionWhileMSGQOp = e;
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
                if (oCookie != null) {
                    ((Disposable)oCookie).dispose();
                }
                if (MQLNTAdapter.this.pendingSends == 0) {
                    MQLNTAdapter.this.wakeupBuffer.put(0, (byte)1);
                }
            }
        });
    }

    public static final String packetToString(ByteBuffer buff) {
        StringBuffer strbuff = new StringBuffer();
        int offset = 0;
        char[] byteArr = new char[8];
        int initialPosition = buff.position();
        while (buff.hasRemaining()) {
            byte b = buff.get();
            String hexRep = Integer.toHexString(b & 0xFF);
            if ((hexRep = hexRep.toUpperCase()).length() == 1) {
                hexRep = "0" + hexRep;
            }
            strbuff.append(hexRep);
            strbuff.append(' ');
            byteArr[offset] = b > 32 && b < 127 ? (int)b : 46;
            if (++offset != 8) continue;
            strbuff.append('|');
            strbuff.append(byteArr);
            strbuff.append('|');
            strbuff.append('\n');
            offset = 0;
        }
        if (offset != 0) {
            int i;
            int nbSpacesMissing = 8 - offset;
            for (i = 0; i < nbSpacesMissing * 3; ++i) {
                strbuff.append(' ');
            }
            strbuff.append('|');
            strbuff.append(byteArr, 0, offset);
            for (i = 0; i < nbSpacesMissing; ++i) {
                strbuff.append(' ');
            }
            strbuff.append('|');
            strbuff.append('\n');
        }
        buff.position(initialPosition);
        return strbuff.toString();
    }

    private static String dump(ByteBuffer byteBuffer) {
        ByteBuffer duplicateBuffer = byteBuffer.duplicate();
        char[] hexChars = new char[duplicateBuffer.limit() * 3];
        int counter = 0;
        boolean newline = false;
        String eol = System.getProperty("line.separator");
        for (int j = 0; j < duplicateBuffer.limit(); ++j) {
            int v = duplicateBuffer.get(j) & 0xFF;
            hexChars[j * 3] = hexArray[v >>> 4];
            hexChars[j * 3 + 1] = hexArray[v & 0xF];
            if (++counter % 8 == 0) {
                hexChars[j * 3 + 2 + 0] = 10;
                continue;
            }
            hexChars[j * 3 + 2] = 32;
        }
        return new String(hexChars);
    }
}

