/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    JdbcCharacterConverters m_converter;

    CharacterSetWithConverter(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId);
        this.m_converter = charConverter;
    }

    static CharacterSet getInstance(int oracleId) {
        JdbcCharacterConverters charConverter = ccFactory.make(oracleId);
        if (charConverter == null) {
            return null;
        }
        CharacterSetWithConverter charSetInstance = null;
        charSetInstance = CharacterSet1Byte.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetSJIS.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetShift.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSet2ByteFixed.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetGB18030.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSet12Byte.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetJAEUC.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetZHTEUC.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        return CharacterSetLCFixed.getInstance(oracleId);
    }

    @Override
    public boolean isLossyFrom(CharacterSet from) {
        return from.getOracleId() != this.getOracleId();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        return source.getOracleId() == this.getOracleId();
    }

    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        return this.m_converter.toUnicodeStringWithReplacement(bytes, offset, count);
    }

    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        return this.m_converter.toUnicodeString(bytes, offset, count);
    }

    @Override
    public byte[] convert(String s) throws SQLException {
        return this.m_converter.toOracleString(s);
    }

    @Override
    public byte[] convertWithReplacement(String s) {
        return this.m_converter.toOracleStringWithReplacement(s);
    }

    @Override
    public byte[] convertWithReplacement(char[] chars, int charOffset, byte[] bytes, int byteOffset, int[] nchars) {
        return this.m_converter.toOracleStringWithReplacement(chars, charOffset, bytes, byteOffset, nchars);
    }

    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        if (from.getOracleId() == this.getOracleId()) {
            return CharacterSetWithConverter.useOrCopy(source, offset, count);
        }
        return this.convert(from.toString(source, offset, count));
    }
}

