/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.datasource;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcMessageCreator;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import java.util.HashMap;
import java.util.Map;

public class DtsSessionFactoryManegaer
extends BcLoggableObject
implements AutoCloseable {
    private Map<String, DtsSessionFactory> dtsSessionFactoryMap = new HashMap<String, DtsSessionFactory>();
    public static final String DTS_NAME_main = "main";
    public static final String MSG_\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d_0_\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u30d5\u30a1\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093 = "\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d '{0}' \u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u30d5\u30a1\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";

    private DtsSessionFactoryManegaer() {
    }

    public static DtsSessionFactoryManegaer getInstance() {
        return SingletonHolder.instance;
    }

    public void addSessionFactory(DtsSessionFactory dtsSessionFactory) throws Exception {
        this.getLogger().info("addSessionFactory:datasourceName=" + dtsSessionFactory.getName());
        if (BcStringUtil.isEmpty(dtsSessionFactory.getName())) {
            String msg = "Datasource name is not defined.";
            throw new Exception(msg);
        }
        this.dtsSessionFactoryMap.put(dtsSessionFactory.getName(), dtsSessionFactory);
    }

    public Map<String, DtsSessionFactory> getSessionFactoryMap() {
        return this.dtsSessionFactoryMap;
    }

    public DtsSessionFactory getSessionFactory(String name) throws Exception {
        return this.dtsSessionFactoryMap.get(name);
    }

    public DtsSessionFactory getSessionFactoryMain() throws Exception {
        return this.getSessionFactory(DTS_NAME_main);
    }

    public DtsSession createSession(String name, Object owner) throws Exception {
        DtsSessionFactory sessionFactory = this.getSessionFactory(name);
        if (sessionFactory == null) {
            String msg = BcMessageCreator.getInstance().bindMessage(MSG_\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u540d_0_\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u30d5\u30a1\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093, name);
            throw new Exception(msg);
        }
        DtsSession dtsSession = sessionFactory.createSession(owner);
        return dtsSession;
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry<String, DtsSessionFactory> mapEntry : this.dtsSessionFactoryMap.entrySet()) {
            DtsSessionFactory sessionFactory = mapEntry.getValue();
            try {
                sessionFactory.close();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }

    /* synthetic */ DtsSessionFactoryManegaer(DtsSessionFactoryManegaer dtsSessionFactoryManegaer) {
        this();
    }

    private static final class SingletonHolder {
        private static final DtsSessionFactoryManegaer instance = new DtsSessionFactoryManegaer(null);

        private SingletonHolder() {
        }
    }
}

