/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLoggableObject;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskEvent;
import ext.lib.task.TskTaskManager;
import ext.lib.task.TskTaskMonitor;
import ext.scf4.fx.HfxTaskMonitorStage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class HfxTaskMonitor
extends BcLoggableObject
implements TskTaskMonitor,
BcEventHandler<TskTaskEvent> {
    private static Map<Integer, TskCallableUnit> callableUnitMap = new ConcurrentHashMap<Integer, TskCallableUnit>();
    List<TskCallableUnit> callableUnitList = new ArrayList<TskCallableUnit>();
    private HfxTaskMonitorStage taskMonitorStage;

    public static HfxTaskMonitor getInstance() {
        return SingletonHolder.instance;
    }

    private HfxTaskMonitor() {
        try {
            this.taskMonitorStage = new HfxTaskMonitorStage();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        ValidationTask validationTask = new ValidationTask();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(validationTask);
        TskTaskManager.getInstance().setTaskMonitor(this);
    }

    protected void validation() throws Exception {
        TskTaskManager taskManager = TskTaskManager.getInstance();
        if (taskManager.getMap().size() <= 0) {
            this.hide();
        }
    }

    public void show() throws Exception {
        this.taskMonitorStage.show();
    }

    public void hide() throws Exception {
        this.taskMonitorStage.hide();
    }

    public void show(String title) throws Exception {
    }

    public void close() throws Exception {
    }

    public void appendData(String str) {
    }

    @Override
    public void addCallableUnit(TskCallableUnit callableUnit) throws Exception {
        this.getLogger().debug("HfxTaskMonitor:addCallableUnit:ID=" + callableUnit.getId());
        if (callableUnit.future != null && callableUnit.future.isDone()) {
            this.getLogger().debug("Callable is done. hashCode=" + callableUnit.callable.hashCode());
            return;
        }
        callableUnitMap.put(callableUnit.callable.hashCode(), callableUnit);
        callableUnit.callable.addEventHandler(this);
        if (callableUnit.eventHandler != null) {
            return;
        }
        this.taskMonitorStage.add(callableUnit);
    }

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            TskAbstractCallable callable = (TskAbstractCallable)event.getSource();
            this.getLogger().debug("Finished:callable.hashCode()=" + callable.hashCode());
            TskCallableUnit callableUnit = callableUnitMap.get(callable.hashCode());
            this.callableUnitList.add(callableUnit);
            this.taskMonitorStage.remove(callableUnit);
        } else {
            event.getEventType();
        }
    }

    /* synthetic */ HfxTaskMonitor(HfxTaskMonitor hfxTaskMonitor) {
        this();
    }

    private static final class SingletonHolder {
        private static final HfxTaskMonitor instance = new HfxTaskMonitor(null);

        private SingletonHolder() {
        }
    }

    public class ValidationTask
    implements Callable {
        public final Object call() throws Exception {
            while (true) {
                try {
                    HfxTaskMonitor.this.validation();
                }
                catch (Exception ex) {
                    HfxTaskMonitor.this.getLogger().error(ex);
                }
                Thread.sleep(1000L);
            }
        }
    }
}

