/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.core.BcStringUtil;
import ext.base.core.BcUnicode;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.module.xfil.fx.XfilCrawlPane;
import ext.module.xfil.fx.XfilImagePane;
import ext.module.xfil.fx.XfilSettingPane;
import ext.module.xfil.fx.XfilUriEntityPane;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;

public class XfilFxHelper {
    private Map<String, Object> instanceMap = new HashMap<String, Object>();
    XfilImagePane imagePane;

    public static XfilFxHelper getInstance() {
        return SingletonHolder.instance;
    }

    private XfilFxHelper() {
    }

    public static String createKey(Collection elementCollection) {
        return BcStringUtil.marge(elementCollection, BcUnicode.Unicode.HYPHEN.string);
    }

    public static String createKey(Object ... objects) {
        List<Object> elementList = BcCollectionUtil.toList(objects);
        return XfilFxHelper.createKey(elementList);
    }

    public static String createKey(Class class_, Object ... objects) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        elementList.add(class_.getName());
        elementList.addAll(BcCollectionUtil.toList(objects));
        return XfilFxHelper.createKey(elementList);
    }

    public Object remove(Class class_, Object ... objects) {
        String Key2 = XfilFxHelper.createKey(class_, objects);
        Object instance = this.instanceMap.remove(Key2);
        return instance;
    }

    public XfilSettingPane openSettingPane() throws Exception {
        String Key2 = XfilFxHelper.createKey(XfilSettingPane.class, new Object[0]);
        XfilSettingPane settingPane = (XfilSettingPane)((Object)this.instanceMap.get(Key2));
        if (settingPane == null) {
            settingPane = new XfilSettingPane();
            this.instanceMap.put(Key2, (Object)settingPane);
        }
        final XfilSettingPane settingPaneWk = settingPane;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (settingPaneWk.stage == null) {
                        settingPaneWk.show();
                    } else {
                        settingPaneWk.stage.toFront();
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        return settingPane;
    }

    public XfilUriEntityPane openUriEntityPane(final long uriEntityId) throws Exception {
        String Key2 = XfilFxHelper.createKey(XfilUriEntityPane.class, uriEntityId);
        XfilUriEntityPane uriEntityPane = (XfilUriEntityPane)((Object)this.instanceMap.get(Key2));
        if (uriEntityPane == null) {
            uriEntityPane = new XfilUriEntityPane();
            this.instanceMap.put(Key2, (Object)uriEntityPane);
        }
        final XfilUriEntityPane uriEntityPaneWk = uriEntityPane;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (uriEntityPaneWk.stage == null) {
                        uriEntityPaneWk.show(uriEntityId);
                    } else {
                        uriEntityPaneWk.stage.toFront();
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        return uriEntityPane;
    }

    public XfilCrawlPane openCrawlPane(final long crawlId) throws Exception {
        String Key2 = XfilFxHelper.createKey(XfilCrawlPane.class, crawlId);
        XfilCrawlPane crawlPane = (XfilCrawlPane)((Object)this.instanceMap.get(Key2));
        if (crawlPane == null) {
            crawlPane = new XfilCrawlPane();
            this.instanceMap.put(Key2, (Object)crawlPane);
        }
        final XfilCrawlPane crawlPaneWk = crawlPane;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (crawlPaneWk.stage == null) {
                        crawlPaneWk.show(crawlId);
                    } else {
                        crawlPaneWk.stage.toFront();
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        return crawlPane;
    }

    public FxBorderPane openImagePane(BufferedImage bufferedImage, double ratio, Point2D.Double awtPoint2d) throws Exception {
        WritableImage image = null;
        if (bufferedImage != null) {
            image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        WritableImage image2 = image;
        FxPlatform.runLater(new Runnable((Image)image2, ratio, awtPoint2d){
            private final /* synthetic */ Image val$image2;
            private final /* synthetic */ double val$ratio;
            private final /* synthetic */ Point2D.Double val$awtPoint2d;
            {
                this.val$image2 = image;
                this.val$ratio = d;
                this.val$awtPoint2d = double_;
            }

            @Override
            public void run() {
                try {
                    if (XfilFxHelper.this.imagePane == null) {
                        XfilFxHelper.this.imagePane = new XfilImagePane();
                    }
                    if (this.val$image2 != null) {
                        XfilFxHelper.this.imagePane.setImage(this.val$image2, this.val$ratio);
                        XfilFxHelper.this.imagePane.stage.sizeToScene();
                        XfilFxHelper.this.imagePane.stage.setX(this.val$awtPoint2d.x);
                        XfilFxHelper.this.imagePane.stage.setY(this.val$awtPoint2d.y);
                        XfilFxHelper.this.imagePane.stage.show();
                        XfilFxHelper.this.imagePane.stage.toFront();
                    } else {
                        XfilFxHelper.this.imagePane.stage.hide();
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        return this.imagePane;
    }

    /* synthetic */ XfilFxHelper(XfilFxHelper xfilFxHelper) {
        this();
    }

    private static final class SingletonHolder {
        private static final XfilFxHelper instance = new XfilFxHelper(null);

        private SingletonHolder() {
        }
    }
}

