/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1FileResource;
import java.util.List;

public class Wbs1FileResourceDAO
extends OrmAbstractDAO<Wbs1FileResource> {
    private Wbs1FileResourceDAO() {
        super(new Wbs1FileResource[0]);
        this.setTableName("wbs1_file_resource");
    }

    public static Wbs1FileResourceDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, Mode mode, String alias, long fileId, String fileName1, String fileName3) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (fileId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + fileId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(fileName1)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "file_name" + sqlContext.toCondition_string("=", fileName1));
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(fileName3)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "file_name_3" + sqlContext.toCondition_string("=", fileName3));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long fileId, String fileName1, String fileName3) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "fr";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, mode, alias, fileId, fileName1, fileName3);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long fileId) throws Exception {
        if (fileId <= 0L) {
            return null;
        }
        String fileName1 = null;
        String fileName3 = null;
        List<T> entityList = this.getList(dtsSession, Mode.id, fileId, fileName1, fileName3);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getByFileName3(DtsSession dtsSession, String fileName3) throws Exception {
        if (BcStringUtil.isEmpty(fileName3)) {
            return null;
        }
        long fileId = -1L;
        String fileName1 = null;
        List<T> entityList = this.getList(dtsSession, Mode.id, fileId, fileName1, fileName3);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1FileResourceDAO(Wbs1FileResourceDAO wbs1FileResourceDAO) {
        this();
    }

    public static enum Mode {
        id("id"),
        fileName1("file_name"),
        fileName3("file_name_3");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1FileResourceDAO instance = new Wbs1FileResourceDAO(null);

        private SingletonHolder() {
        }
    }
}

