/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class NamespaceContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodeIterator iterator;
    private NodePointer currentNodePointer;

    public NamespaceContext(EvalContext parentContext, NodeTest nodeTest) {
        super(parentContext);
        this.nodeTest = nodeTest;
    }

    @Override
    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    @Override
    public void reset() {
        this.setStarted = false;
        this.iterator = null;
        super.reset();
    }

    @Override
    public boolean setPosition(int position) {
        if (position < this.getCurrentPosition()) {
            this.reset();
        }
        while (this.getCurrentPosition() < position) {
            if (this.nextNode()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean nextNode() {
        super.setPosition(this.getCurrentPosition() + 1);
        if (!this.setStarted) {
            this.setStarted = true;
            if (!(this.nodeTest instanceof NodeNameTest)) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)this.nodeTest;
            QName testName = nodeNameTest.getNodeName();
            if (testName.getPrefix() != null) {
                return false;
            }
            if (nodeNameTest.isWildcard()) {
                this.iterator = this.parentContext.getCurrentNodePointer().namespaceIterator();
            } else {
                this.currentNodePointer = this.parentContext.getCurrentNodePointer().namespacePointer(testName.getName());
                return this.currentNodePointer != null;
            }
        }
        if (this.iterator == null) {
            return false;
        }
        if (!this.iterator.setPosition(this.iterator.getPosition() + 1)) {
            return false;
        }
        this.currentNodePointer = this.iterator.getNodePointer();
        return true;
    }
}

