/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.stub.XfilUriEntityStub;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class XfilUriEntityPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField directoryField = new FxTextField();
    FxTextField fileNameField = new FxTextField();
    FxTextField tagField = new FxTextField();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XfilUriEntity uriEntity1;
    Stage stage;

    public XfilUriEntityPane() throws Exception {
        this.directoryField.setPrefColumnCount(80);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().CrawlName.toPlain()), new Node[]{this.directoryField});
        this.centerPane.addNodeUnit(controlUnit);
        this.fileNameField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().tag), new Node[]{this.fileNameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.tagField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().tag), new Node[]{this.tagField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(XfilUriEntity uriEntity) throws Exception {
        this.uriEntity1 = uriEntity;
        this.directoryField.setText(uriEntity.directory);
        this.fileNameField.setText(uriEntity.name);
        this.tagField.setText(uriEntity.text01);
    }

    protected void storeData(XfilUriEntity uriEntity) throws Exception {
        uriEntity.directory = this.directoryField.getText();
        uriEntity.name = this.fileNameField.getText();
        uriEntity.text01 = this.tagField.getText();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData(this.uriEntity1);
            XfilUriEntityStub.getInstance().putUriEntity(this.uriEntity1);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), this.uriEntity1.id);
    }

    public void show(long uriEntityId) throws Exception {
        XfilUriEntity uriEntity = XfilUriEntityStub.getInstance().getUriEntity(uriEntityId);
        this.setData(uriEntity);
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(320.0);
        this.stage.setResizable(false);
        this.stage.setTitle(XfilWords.getInstance().Crawl.toPlain());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

