/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsWords;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TablePosition;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsAbstractTableSelectPane<T>
extends FxDecoratePane {
    protected InnerTableView tableView;
    protected Number selectedRowId;
    protected Object selectedValue;
    protected Button selectButton;
    protected Button closeButton;
    protected Stage stage;

    public XdtsAbstractTableSelectPane() throws Exception {
        this.selectButton = this.createButton(BcWords.getInstance().select);
        this.closeButton = this.createButton(BcWords.getInstance().close);
    }

    protected void setData(BcTableColumnModel tableColumnModel, FxTableRowList tableRowObservableList) throws Exception {
        this.tableView = new InnerTableView();
        FxTableUtil.createColumn(tableColumnModel, this.tableView, null);
        this.tableView.setItems(tableRowObservableList);
        this.setCenter((Node)this.tableView);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.selectButton) {
            FxTableRowList tableRowList = (FxTableRowList)this.tableView.getItems();
            this.selectedValue = tableRowList.getTableModel().getValueAt(this.selectedRowId.intValue(), 0);
            this.close();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    protected void rowSelected(int rowId) throws Exception {
        FxTableRowList tableRowList = (FxTableRowList)this.tableView.getItems();
        this.selectedValue = tableRowList.getTableModel().getValueAt(rowId, 0);
        this.close();
    }

    public void close() {
        this.stage.close();
    }

    public <T> Object show(Window ownerWindow) throws Exception {
        this.selectedValue = null;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(600.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().dataSourceList);
        this.stage.showAndWait();
        return this.selectedValue;
    }

    static /* synthetic */ void access$0(XdtsAbstractTableSelectPane xdtsAbstractTableSelectPane, Throwable throwable) {
        xdtsAbstractTableSelectPane.handleException(throwable);
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            XdtsAbstractTableSelectPane.this.selectedRowId = nextRowId;
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            if (doubleClicked) {
                TablePosition tablePosition = (TablePosition)tablePositionList.get(0);
                XdtsAbstractTableSelectPane.this.rowSelected(tablePosition.getRow());
            }
        }
    }
}

